/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ManaCostSummaryWidget
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/mana_cost_summary_widget.png");
    protected static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    protected SourceList manaCosts;

    public ManaCostSummaryWidget(SourceList manaCosts, int x, int y) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.manaCosts = manaCosts;
        Minecraft mc = Minecraft.getInstance();
        MutableComponent tooltip = Component.empty();
        if (this.manaCosts.isEmpty()) {
            tooltip.append((Component)Component.translatable((String)"label.primalmagick.crafting.no_mana"));
        } else {
            tooltip.append((Component)Component.translatable((String)"label.primalmagick.crafting.mana_cost_header"));
            for (Source source : this.manaCosts.getSourcesSorted()) {
                boolean discovered = source.isDiscovered((Player)mc.player);
                Component sourceText = discovered ? source.getNameText() : Component.translatable((String)Source.getUnknownTranslationKey());
                tooltip.append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"label.primalmagick.crafting.mana", (Object[])new Object[]{MANA_FORMATTER.format((double)this.manaCosts.getAmount(source) / 100.0), sourceText}));
            }
        }
        this.setTooltip(Tooltip.create((Component)tooltip));
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
        guiGraphics.blit(TEXTURE, 0, 0, 0, 0, 255, 255);
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

