/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class KnowledgeWidget
extends AbstractWidget {
    protected static final ResourceLocation GRIMOIRE_TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    protected KnowledgeType type;
    protected int amount;
    protected boolean isComplete;

    public KnowledgeWidget(KnowledgeType type, int amount, int x, int y, boolean isComplete) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.type = type;
        this.amount = amount;
        this.isComplete = isComplete;
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)this.type.getNameTranslationKey())));
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
        guiGraphics.blit(this.type.getIconLocation(), 0, 0, 0, 0, 255, 255);
        guiGraphics.pose().popPose();
        MutableComponent amountText = Component.literal((String)Integer.toString(this.amount));
        int width = mc.font.width(amountText.getString());
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 5.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        guiGraphics.drawString(mc.font, (Component)amountText, 0, 0, this.isComplete ? Color.WHITE.getRGB() : Color.RED.getRGB());
        guiGraphics.pose().popPose();
        if (this.isComplete) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 8), (float)this.getY(), 100.0f);
            guiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 159, 207, 10, 10);
            guiGraphics.pose().popPose();
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

