/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemTagWidget
extends AbstractWidget {
    protected static final ResourceLocation GRIMOIRE_TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    protected final TagKey<Item> tag;
    protected final int amount;
    protected final boolean isComplete;
    protected ItemStack lastStack = ItemStack.EMPTY;
    protected ItemStack currentStack = ItemStack.EMPTY;

    public ItemTagWidget(TagKey<Item> tag, int amount, int x, int y, boolean isComplete) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.tag = tag;
        this.amount = amount;
        this.isComplete = isComplete;
    }

    public ItemTagWidget(TagKey<Item> tag, int x, int y, boolean isComplete) {
        this(tag, 1, x, y, isComplete);
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        this.lastStack = this.currentStack;
        this.currentStack = this.getDisplayStack();
        if (!this.currentStack.isEmpty()) {
            GuiUtils.renderItemStack(guiGraphics, this.currentStack, this.getX(), this.getY(), this.getMessage().getString(), false);
            if (this.amount > 1) {
                MutableComponent amountText = Component.literal((String)Integer.toString(this.amount));
                int width = mc.font.width(amountText.getString());
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 200.0f);
                guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
                guiGraphics.drawString(mc.font, (Component)amountText, 0, 0, Color.WHITE.getRGB());
                guiGraphics.pose().popPose();
            }
            if (this.isComplete) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(this.getX() + 8), (float)this.getY(), 200.0f);
                guiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 159, 207, 10, 10);
                guiGraphics.pose().popPose();
            }
            this.updateTooltip();
        }
        this.setFocused(false);
    }

    protected void updateTooltip() {
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.currentStack, (ItemStack)this.lastStack)) {
            Minecraft mc = Minecraft.getInstance();
            this.setTooltip(Tooltip.create((Component)CommonComponents.joinLines((Collection)this.currentStack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)))));
        }
    }

    @Nonnull
    protected ItemStack getDisplayStack() {
        ArrayList tagContents = new ArrayList();
        Services.ITEMS_REGISTRY.getTag(this.tag).forEach(tagContents::add);
        if (!tagContents.isEmpty()) {
            int index = (int)(System.currentTimeMillis() / 1000L % (long)tagContents.size());
            return new ItemStack((ItemLike)tagContents.get(index), this.amount);
        }
        return ItemStack.EMPTY;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

