/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.research.topics.OtherResearchTopic;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientWidget
extends Button {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Ingredient ingredient;
    protected final GrimoireScreen screen;
    protected ItemStack lastStack = ItemStack.EMPTY;
    protected ItemStack currentStack = ItemStack.EMPTY;

    public IngredientWidget(@Nullable Ingredient ingredient, int x, int y, GrimoireScreen screen) {
        super(x, y, 16, 16, (Component)Component.empty(), (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
        this.ingredient = ingredient;
        this.screen = screen;
    }

    public GrimoireScreen getScreen() {
        return this.screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        this.lastStack = this.currentStack;
        this.currentStack = this.getDisplayStack();
        if (!this.currentStack.isEmpty()) {
            GuiUtils.renderItemStack(guiGraphics, this.currentStack, this.getX(), this.getY(), this.getMessage().getString(), false);
            this.updateTooltip();
        }
        this.setFocused(false);
    }

    protected boolean isValidClickButton(int p_93652_) {
        ItemStack displayStack = this.getDisplayStack();
        return super.isValidClickButton(p_93652_) && !displayStack.isEmpty() && this.screen.isIndexKey(displayStack.getHoverName().getString());
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
    }

    protected void updateTooltip() {
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.currentStack, (ItemStack)this.lastStack)) {
            Minecraft mc = Minecraft.getInstance();
            this.setTooltip(Tooltip.create((Component)CommonComponents.joinLines((Collection)this.currentStack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)))));
        }
    }

    @Nonnull
    protected ItemStack getDisplayStack() {
        ItemStack[] matching;
        if (this.ingredient != null && (matching = this.ingredient.getItems()) != null && matching.length > 0) {
            int index = (int)(System.currentTimeMillis() / 1000L % (long)matching.length);
            return matching[index];
        }
        return ItemStack.EMPTY;
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof IngredientWidget) {
                IngredientWidget iw = (IngredientWidget)button;
                iw.getScreen().gotoTopic(new OtherResearchTopic(iw.getDisplayStack().getHoverName().getString(), 0));
            }
        }
    }
}

