/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ExpertiseProgressWidget
extends AbstractWidget {
    protected static final ResourceLocation GRIMOIRE_TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    protected final ResearchDisciplineKey disciplineKey;
    protected final ResearchTier tier;
    protected final int maxValue;
    protected final int currentValue;
    protected final boolean isComplete;
    protected MutableComponent lastTooltip = Component.empty();
    protected MutableComponent tooltip = Component.empty();

    public ExpertiseProgressWidget(ResearchDisciplineKey disciplineKey, ResearchTier tier, int maxProgressValue, int x, int y, boolean isComplete) {
        super(x, y, 16, 18, (Component)Component.empty());
        Minecraft mc = Minecraft.getInstance();
        this.disciplineKey = disciplineKey;
        this.tier = tier;
        this.maxValue = maxProgressValue;
        this.currentValue = ExpertiseManager.getValue((Player)mc.player, disciplineKey).orElse(0);
        this.isComplete = isComplete;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.tier.getIconDefinition().ifPresent(iconDef -> GuiUtils.renderIconFromDefinition(pGuiGraphics, iconDef, this.getX(), this.getY()));
        if (this.isComplete) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate((float)(this.getX() + 8), (float)this.getY(), 100.0f);
            pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 159, 207, 10, 10);
            pGuiGraphics.pose().popPose();
        }
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 0.0f);
        pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 0, 234, 16, 2);
        pGuiGraphics.pose().popPose();
        int px = this.getProgressionScaled();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)(this.getY() + 17), 1.0f);
        pGuiGraphics.blit(GRIMOIRE_TEXTURE, 0, 0, 0, 232, px, 2);
        pGuiGraphics.pose().popPose();
        Minecraft mc = Minecraft.getInstance();
        this.lastTooltip = this.tooltip;
        this.tooltip = Component.empty();
        ExpertiseManager.getStat(mc.player.level().registryAccess(), this.disciplineKey).flatMap(Stat::getHintTranslationKey).ifPresentOrElse(hintTranslationKey -> {
            if (Screen.hasShiftDown()) {
                this.tooltip.append((Component)Component.translatable((String)hintTranslationKey));
            } else {
                this.tooltip.append(this.getStatDescription());
                this.tooltip.append(CommonComponents.NEW_LINE);
                this.tooltip.append((Component)Component.translatable((String)"tooltip.primalmagick.more_info").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        }, () -> this.tooltip.append(this.getStatDescription()));
        if (!this.lastTooltip.equals((Object)this.tooltip)) {
            this.setTooltip(Tooltip.create((Component)this.tooltip));
        }
    }

    protected Component getStatDescription() {
        Minecraft mc = Minecraft.getInstance();
        Optional<Stat> statOpt = ExpertiseManager.getStat(mc.player.level().registryAccess(), this.disciplineKey);
        if (statOpt.isPresent()) {
            Stat stat = statOpt.get();
            MutableComponent baseDescription = Component.translatable((String)stat.getTranslationKey());
            String currentValue = stat.formatter().format(Math.min(this.currentValue, this.maxValue));
            String maxValue = stat.formatter().format(this.maxValue);
            return Component.translatable((String)"tooltip.primalmagick.stat_progress", (Object[])new Object[]{baseDescription, currentValue, maxValue});
        }
        return Component.empty();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }

    protected int getProgressionScaled() {
        int i = this.currentValue;
        int j = this.maxValue;
        return j != 0 && i != 0 ? (int)(16.0 * ((double)i / (double)j)) : 0;
    }
}

