/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.AbstractTopicButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IndexIconFactory;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncProgressPacket;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncResearchFlagsPacket;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.topics.EntryResearchTopic;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class EntryButton
extends AbstractTopicButton {
    protected ResearchEntry entry;

    public EntryButton(int x, int y, Component text, GrimoireScreen screen, ResearchEntry entry, boolean showIcon) {
        super(x, y, 123, 12, text, screen, showIcon ? IndexIconFactory.fromEntryIcon(entry.iconOpt().orElse(null), false) : null, new Handler());
        this.entry = entry;
    }

    public ResearchEntry getEntry() {
        return this.entry;
    }

    @Override
    protected boolean isHighlighted() {
        Minecraft mc = Minecraft.getInstance();
        return this.entry.isHighlighted((Player)mc.player);
    }

    @Override
    protected boolean isUnread() {
        Minecraft mc = Minecraft.getInstance();
        return this.entry.isUnread((Player)mc.player);
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof EntryButton) {
                EntryButton geb = (EntryButton)button;
                Minecraft mc = Minecraft.getInstance();
                geb.getScreen().pushCurrentHistoryTopic();
                geb.getScreen().setTopic(new EntryResearchTopic(geb.getEntry().key(), 0));
                Services.CAPABILITIES.knowledge((Player)mc.player).ifPresent(knowledge -> {
                    knowledge.removeResearchFlag(geb.getEntry().key(), IPlayerKnowledge.ResearchFlag.NEW);
                    knowledge.removeResearchFlag(geb.getEntry().key(), IPlayerKnowledge.ResearchFlag.UPDATED);
                    knowledge.removeResearchFlag(geb.getEntry().key(), IPlayerKnowledge.ResearchFlag.HIGHLIGHT);
                    knowledge.addResearchFlag(geb.getEntry().key(), IPlayerKnowledge.ResearchFlag.READ);
                    PacketHandler.sendToServer(new SyncResearchFlagsPacket((Player)mc.player, geb.getEntry().key()));
                });
                if (!ResearchManager.isResearchStarted((Player)mc.player, geb.getEntry().key())) {
                    PacketHandler.sendToServer(new SyncProgressPacket(geb.getEntry().key(), true, false, true, false));
                }
                mc.setScreen((Screen)new GrimoireScreen());
            }
        }
    }
}

