/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.stats.ExpertiseManager;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentExpertiseWidget
extends AbstractWidget {
    protected static final ResourceLocation ICON_LOC = ResourceUtils.loc("textures/research/expertise_expert.png");
    protected final Holder<Enchantment> enchantment;

    public EnchantmentExpertiseWidget(Holder<Enchantment> ench, int x, int y) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.enchantment = ench;
        this.setTooltip(Tooltip.create((Component)EnchantmentExpertiseWidget.makeTooltipComponent(ench)));
    }

    protected static Component makeTooltipComponent(Holder<Enchantment> ench) {
        Minecraft mc = Minecraft.getInstance();
        MutableComponent retVal = Component.empty();
        RuneManager.getRuneDefinition(mc.level.registryAccess(), ench).ifPresent(runeEnchDef -> ExpertiseManager.getRuneEnchantmentTier(mc.level.registryAccess(), runeEnchDef).ifPresent(tier -> {
            retVal.append((Component)Component.translatable((String)"tooltip.primalmagick.expertise.base", (Object[])new Object[]{tier.getDefaultExpertise()}));
            retVal.append(CommonComponents.NEW_LINE);
            MutableComponent bonusLine = Component.translatable((String)"tooltip.primalmagick.expertise.bonus", (Object[])new Object[]{tier.getDefaultBonusExpertise()});
            if (ExpertiseManager.isBonusEligible((Player)mc.player, ench)) {
                retVal.append((Component)bonusLine);
            } else {
                retVal.append((Component)bonusLine.withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.STRIKETHROUGH}));
                retVal.append((Component)Component.translatable((String)"tooltip.primalmagick.expertise.claimed"));
            }
        }));
        return retVal;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        pGuiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        pGuiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
        pGuiGraphics.blit(ICON_LOC, 0, 0, 0, 0, 255, 255);
        pGuiGraphics.pose().popPose();
        this.setFocused(false);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

