/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.AbstractTopicButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.GenericIndexIcon;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.topics.DisciplineResearchTopic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class DisciplineButton
extends AbstractTopicButton {
    protected final ResearchDiscipline discipline;

    public DisciplineButton(int widthIn, int heightIn, Component text, GrimoireScreen screen, ResearchDiscipline discipline, boolean showIcon, boolean enlarge) {
        super(widthIn, heightIn, 123, enlarge ? 17 : 12, text, screen, showIcon ? GenericIndexIcon.of(discipline.iconLocation(), true) : null, new Handler());
        Minecraft mc = Minecraft.getInstance();
        this.discipline = discipline;
        int unreadCount = this.discipline.getUnreadEntryCount((Player)mc.player);
        if (unreadCount == 1) {
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.primalmagick.unread_count.entry.single")));
        } else if (unreadCount > 0) {
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.primalmagick.unread_count.entry.multiple", (Object[])new Object[]{unreadCount})));
        }
    }

    public ResearchDiscipline getDiscipline() {
        return this.discipline;
    }

    @Override
    protected boolean isHighlighted() {
        Minecraft mc = Minecraft.getInstance();
        return this.discipline.isHighlighted((Player)mc.player);
    }

    @Override
    protected boolean isUnread() {
        Minecraft mc = Minecraft.getInstance();
        return this.discipline.isUnread((Player)mc.player);
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof DisciplineButton) {
                DisciplineButton gdb = (DisciplineButton)button;
                gdb.getScreen().gotoTopic(new DisciplineResearchTopic(gdb.getDiscipline().key(), 0));
            }
        }
    }
}

