/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockIngredientWidget
extends AbstractWidget {
    protected final BlockIngredient ingredient;
    protected ItemStack lastStack = ItemStack.EMPTY;
    protected ItemStack currentStack = ItemStack.EMPTY;

    public BlockIngredientWidget(@Nullable BlockIngredient ingredient, int xIn, int yIn) {
        super(xIn, yIn, 16, 16, (Component)Component.empty());
        this.ingredient = ingredient;
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        this.lastStack = this.currentStack;
        this.currentStack = this.getDisplayStack();
        if (!this.currentStack.isEmpty()) {
            GuiUtils.renderItemStack(guiGraphics, this.currentStack, this.getX(), this.getY(), this.getMessage().getString(), false);
            this.updateTooltip();
        }
        this.setFocused(false);
    }

    protected void updateTooltip() {
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.currentStack, (ItemStack)this.lastStack)) {
            Minecraft mc = Minecraft.getInstance();
            this.setTooltip(Tooltip.create((Component)CommonComponents.joinLines((Collection)this.currentStack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL)))));
        }
    }

    @Nonnull
    protected ItemStack getDisplayStack() {
        Block[] matching;
        if (this.ingredient != null && (matching = this.ingredient.getMatchingBlocks()) != null && matching.length > 0) {
            int index = (int)(System.currentTimeMillis() / 1000L % (long)matching.length);
            Block block = matching[index];
            if (block == null) {
                ItemStack retVal = new ItemStack((ItemLike)Blocks.BARRIER);
                retVal.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"grimoire.primalmagick.missing_block"));
                return retVal;
            }
            return new ItemStack((ItemLike)block);
        }
        return ItemStack.EMPTY;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

