/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class BackButton
extends Button {
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    private static final ResourceLocation UNREAD_SPRITE = ResourceUtils.loc("grimoire/unread");
    private static final int UNREAD_WIDTH = 16;
    private static final int UNREAD_HEIGHT = 16;
    protected GrimoireScreen screen;

    public BackButton(int x, int y, GrimoireScreen screen) {
        super(x, y, 16, 8, (Component)Component.empty(), (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
        this.screen = screen;
        Minecraft mc = Minecraft.getInstance();
        this.screen.getPreviousTopic().flatMap(topic -> topic.getUnreadTooltip((Player)mc.player)).ifPresent(component -> this.setTooltip(Tooltip.create((Component)component)));
    }

    public GrimoireScreen getScreen() {
        return this.screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        float scaleMod = this.isHoveredOrFocused() ? Mth.sin((float)((float)mc.player.tickCount / 3.0f)) * 0.2f + 0.1f : 0.0f;
        int dx = this.width / 2;
        int dy = this.height / 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.getX() + dx), (float)(this.getY() + dy), 0.0f);
        guiGraphics.pose().scale(1.5f + scaleMod, 1.5f + scaleMod, 1.0f);
        guiGraphics.blit(TEXTURE, -dx, -dy, 40, 204, this.width, this.height);
        guiGraphics.pose().popPose();
        if (this.screen.getPreviousTopic().map(topic -> topic.isUnread((Player)mc.player)).orElse(false).booleanValue()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + dx + 1), (float)(this.getY() - dy), 5.0f);
            guiGraphics.pose().scale(0.4f, 0.4f, 1.0f);
            guiGraphics.blitSprite(UNREAD_SPRITE, 0, 0, 16, 16);
            guiGraphics.pose().popPose();
        }
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void onPress(Button button) {
            if (button instanceof BackButton) {
                BackButton gbb = (BackButton)button;
                gbb.getScreen().goBack();
            }
        }
    }
}

