/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AttunementThresholdWidget
extends AbstractWidget {
    protected static final ItemStack WAND_STACK = (ItemStack)Util.make((Object)new ItemStack((ItemLike)ItemsPM.MODULAR_WAND.get()), stack -> {
        ItemsPM.MODULAR_WAND.get().setWandCore((ItemStack)stack, WandCore.HEARTWOOD);
        ItemsPM.MODULAR_WAND.get().setWandCap((ItemStack)stack, WandCap.IRON);
        ItemsPM.MODULAR_WAND.get().setWandGem((ItemStack)stack, WandGem.APPRENTICE);
    });
    protected static final ItemStack SHACKLED_OVERLAY_STACK = new ItemStack((ItemLike)Items.BARRIER);
    protected final Source source;
    protected final AttunementThreshold threshold;
    protected final boolean suppressed;
    protected final ResourceLocation texture;

    public AttunementThresholdWidget(@Nonnull Source source, @Nonnull AttunementThreshold threshold, int x, int y) {
        super(x, y, 18, 18, (Component)Component.empty());
        this.source = source;
        this.threshold = threshold;
        Minecraft mc = Minecraft.getInstance();
        this.suppressed = AttunementManager.isSuppressed((Player)mc.player, source);
        this.texture = ResourceUtils.loc("textures/attunements/threshold_" + source.getId().getPath() + "_" + threshold.getTag() + ".png");
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.translatable((String)String.join((CharSequence)".", "attunement_threshold", "primalmagick", threshold.getTag(), source.getId().getPath())));
        if (this.suppressed) {
            lines.add(Component.translatable((String)"tooltip.primalmagick.attunement_shackles.shackled").withStyle(ChatFormatting.RED));
        }
        this.setTooltip(Tooltip.create((Component)CommonComponents.joinLines(lines)));
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        if (this.threshold == AttunementThreshold.MINOR) {
            guiGraphics.renderItem(WAND_STACK, this.getX() + 1, this.getY() + 1);
        } else {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
            guiGraphics.pose().scale(0.0703125f, 0.0703125f, 0.0703125f);
            guiGraphics.blit(this.texture, 0, 0, 0, 0, 255, 255);
            guiGraphics.pose().popPose();
        }
        if (this.suppressed) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 1), (float)(this.getY() + 1), 1.0f);
            guiGraphics.renderItem(SHACKLED_OVERLAY_STACK, 0, 0);
            guiGraphics.pose().popPose();
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

