/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class AttunementMeterWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/attunement_meter.png");
    protected final Source source;
    protected final Color permanentColor;
    protected final Color inducedColor;
    protected final Color temporaryColor;

    public AttunementMeterWidget(@Nonnull Source source, int x, int y) {
        super(x, y, 12, 102, (Component)Component.empty());
        this.source = source;
        Color baseColor = new Color(this.source.getColor());
        this.permanentColor = baseColor.darker();
        this.inducedColor = baseColor;
        this.temporaryColor = baseColor.brighter();
        Minecraft mc = Minecraft.getInstance();
        int p = AttunementManager.getAttunement((Player)mc.player, this.source, AttunementType.PERMANENT);
        int i = AttunementManager.getAttunement((Player)mc.player, this.source, AttunementType.INDUCED);
        int t = AttunementManager.getAttunement((Player)mc.player, this.source, AttunementType.TEMPORARY);
        MutableComponent tooltip = Component.translatable((String)"grimoire.primalmagick.attunement_meter.tooltip.header", (Object[])new Object[]{this.source.getNameText()}).append(CommonComponents.NEW_LINE);
        tooltip.append((Component)Component.translatable((String)"grimoire.primalmagick.attunement_meter.tooltip.permanent", (Object[])new Object[]{p})).append(CommonComponents.NEW_LINE);
        if (i > 0) {
            tooltip.append((Component)Component.translatable((String)"grimoire.primalmagick.attunement_meter.tooltip.induced", (Object[])new Object[]{i})).append(CommonComponents.NEW_LINE);
        }
        tooltip.append((Component)Component.translatable((String)"grimoire.primalmagick.attunement_meter.tooltip.temporary", (Object[])new Object[]{t}));
        this.setTooltip(Tooltip.create((Component)tooltip));
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft mc = Minecraft.getInstance();
        int p = AttunementManager.getAttunement((Player)mc.player, this.source, AttunementType.PERMANENT);
        int i = AttunementManager.getAttunement((Player)mc.player, this.source, AttunementType.INDUCED);
        int t = AttunementManager.getAttunement((Player)mc.player, this.source, AttunementType.TEMPORARY);
        guiGraphics.setColor((float)this.permanentColor.getRed() / 255.0f, (float)this.permanentColor.getGreen() / 255.0f, (float)this.permanentColor.getBlue() / 255.0f, 1.0f);
        guiGraphics.blit(TEXTURE, this.getX() + 1, this.getY() + 1 + (100 - Mth.clamp((int)p, (int)0, (int)100)), 0, 10, 10, Mth.clamp((int)p, (int)0, (int)100));
        guiGraphics.setColor((float)this.inducedColor.getRed() / 255.0f, (float)this.inducedColor.getGreen() / 255.0f, (float)this.inducedColor.getBlue() / 255.0f, 1.0f);
        guiGraphics.blit(TEXTURE, this.getX() + 1, this.getY() + 1 + (100 - Mth.clamp((int)(p + i), (int)0, (int)100)), 0, 10, 10, Mth.clamp((int)i, (int)0, (int)(100 - p)));
        guiGraphics.setColor((float)this.temporaryColor.getRed() / 255.0f, (float)this.temporaryColor.getGreen() / 255.0f, (float)this.temporaryColor.getBlue() / 255.0f, 1.0f);
        guiGraphics.blit(TEXTURE, this.getX() + 1, this.getY() + 1 + (100 - Mth.clamp((int)(p + i + t), (int)0, (int)100)), 0, 10, 10, Mth.clamp((int)t, (int)0, (int)(100 - p - i)));
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(TEXTURE, this.getX(), this.getY(), 29, 9, 12, 102);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }
}

