/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.datafixers.util.Either;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.AbstractTopicButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemIndexIcon;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.affinities.AffinityIndexEntry;
import com.verdantartifice.primalmagick.common.affinities.AffinityTooltipComponent;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AffinityRecordWidget
extends AbstractTopicButton {
    public static final int WIDGET_HEIGHT = 17;
    protected final AffinityIndexEntry entry;
    protected final Source source;
    protected final Component amountText;
    protected final List<Either<FormattedText, TooltipComponent>> elements = new ArrayList<Either<FormattedText, TooltipComponent>>();

    public AffinityRecordWidget(int x, int y, @NotNull AffinityIndexEntry entry, Source source, GrimoireScreen screen) {
        super(x, y, 123, 17, entry.stack().getHoverName(), screen, ItemIndexIcon.of((ItemLike)entry.stack().getItem(), true), button -> {});
        this.entry = entry;
        this.source = source;
        this.amountText = Component.literal((String)Integer.toString(this.entry.affinities().join().getAmount(this.source)));
        this.elements.add((Either<FormattedText, TooltipComponent>)Either.left((Object)Component.translatable((String)"tooltip.primalmagick.affinities.label")));
        this.elements.add((Either<FormattedText, TooltipComponent>)Either.right((Object)new AffinityTooltipComponent(this.entry.affinities().join())));
    }

    @Override
    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        Minecraft mc = Minecraft.getInstance();
        int width = mc.font.width((FormattedText)this.amountText);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 200.0f);
        pGuiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        pGuiGraphics.drawString(mc.font, this.amountText, 0, 0, Color.WHITE.getRGB());
        pGuiGraphics.pose().popPose();
        if (this.isHoveredOrFocused()) {
            GuiUtils.renderComponentTooltipFromElements(pGuiGraphics, this.elements, pMouseX, pMouseY);
        }
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }
}

