/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.AbstractIndexIcon;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public abstract class AbstractTopicButton
extends Button {
    protected static final ResourceLocation UNREAD_SPRITE = ResourceUtils.loc("grimoire/unread");
    protected static final int UNREAD_WIDTH = 16;
    protected static final int UNREAD_HEIGHT = 16;
    protected GrimoireScreen screen;
    protected AbstractIndexIcon icon;

    public AbstractTopicButton(int x, int y, int width, int height, Component text, GrimoireScreen screen, AbstractIndexIcon icon, Button.OnPress onPress) {
        super(x, y, width, height, text, onPress, Button.DEFAULT_NARRATION);
        this.screen = screen;
        this.icon = icon;
    }

    public GrimoireScreen getScreen() {
        return this.screen;
    }

    protected boolean isHighlighted() {
        return false;
    }

    protected boolean isUnread() {
        return false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (this.isHoveredOrFocused()) {
            int alpha = 34;
            int color = alpha << 24;
            guiGraphics.fill(this.getX() - 5, this.getY(), this.getX() + this.width + 5, this.getY() + this.height, color);
        }
        int strWidth = mc.font.width(this.getMessage().getString());
        int dx = this.icon == null ? 0 : (this.icon.isLarge() ? 16 : 11);
        Objects.requireNonNull(mc.font);
        int dy = (this.height - 9) / 2;
        if (strWidth <= this.width - dx) {
            guiGraphics.drawString(mc.font, this.getMessage(), this.getX() + dx, this.getY() + dy, Color.BLACK.getRGB(), false);
        } else {
            float scale = (float)(this.width - dx) / (float)strWidth;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + dx), (float)(this.getY() + dy) + 1.0f * scale, 0.0f);
            guiGraphics.pose().scale(scale, scale, scale);
            guiGraphics.drawString(mc.font, this.getMessage(), 0, 0, Color.BLACK.getRGB(), false);
            guiGraphics.pose().popPose();
        }
        if (this.icon != null) {
            if (this.isHighlighted()) {
                float scaleMod = Mth.sin((float)((float)mc.player.tickCount / 3.0f)) * 0.2f + 1.1f;
                this.icon.render(guiGraphics, this.getX() - 2, this.getY() + dy - (this.icon.isLarge() ? 4 : 1), scaleMod);
            } else {
                this.icon.render(guiGraphics, this.getX() - 2, this.getY() + dy - (this.icon.isLarge() ? 4 : 1));
            }
            if (this.isUnread()) {
                float s = this.icon.isLarge() ? 0.5f : 0.4f;
                int dx2 = this.icon.isLarge() ? 11 : 7;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(this.getX() + dx2 - 2), (float)(this.getY() + dy - (this.icon.isLarge() ? 4 : 1) - 2), 5.0f);
                guiGraphics.pose().scale(s, s, 1.0f);
                guiGraphics.blitSprite(UNREAD_SPRITE, 0, 0, 16, 16);
                guiGraphics.pose().popPose();
            }
        }
        guiGraphics.pose().popPose();
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
    }
}

