/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class VocabularyWidget
extends AbstractWidget {
    private static final ResourceLocation BORDER_SPRITE = ResourceUtils.loc("scribe_table/glyph_border");
    protected Holder<BookLanguage> language;
    protected int amount;

    public VocabularyWidget(Holder<BookLanguage> language, int amount, int xIn, int yIn) {
        super(xIn, yIn, 16, 16, (Component)Component.empty());
        this.language = language;
        this.amount = amount;
    }

    public Holder<BookLanguage> getLanguage() {
        return this.language;
    }

    public void setLanguage(Holder<BookLanguage> language) {
        this.language = language;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        pGuiGraphics.blitSprite(BORDER_SPRITE, 0, 0, 16, 16);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(4.0f, 4.0f, 2.0f);
        pGuiGraphics.blitSprite(((BookLanguage)this.getLanguage().value()).getGlyphSprite(), 0, 0, 8, 8);
        pGuiGraphics.pose().popPose();
        pGuiGraphics.pose().pushPose();
        MutableComponent amountText = Component.literal((String)Integer.toString(this.getAmount()));
        int width = mc.font.width(amountText.getString());
        pGuiGraphics.pose().translate((float)(16 - width / 2), 12.0f, 5.0f);
        pGuiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        pGuiGraphics.drawString(mc.font, (Component)amountText, 0, 0, Color.WHITE.getRGB());
        pGuiGraphics.pose().popPose();
        pGuiGraphics.pose().popPose();
        if (this.isHoveredOrFocused()) {
            Services.GUI_GRAPHICS.renderComponentTooltip(pGuiGraphics, mc.font, Collections.singletonList(Component.translatable((String)"tooltip.primalmagick.scribe_table.widget.language", (Object[])new Object[]{((BookLanguage)this.getLanguage().value()).getName(), this.getAmount()})), pMouseX, pMouseY, ItemStack.EMPTY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

