/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collections;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ManaGaugeWidget
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/mana_gauge.png");
    protected static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    protected final Source source;
    protected int maxAmount;
    protected int curAmount;

    public ManaGaugeWidget(int xPos, int yPos, Source source, int curAmount, int maxAmount) {
        super(xPos, yPos, 12, 52, (Component)Component.empty());
        this.source = source;
        this.curAmount = curAmount;
        this.maxAmount = maxAmount;
    }

    public void setPosition(int newX, int newY) {
        this.setX(newX);
        this.setY(newY);
    }

    public void setCurrentMana(int amount) {
        this.curAmount = amount;
    }

    public void setMaxMana(int amount) {
        this.maxAmount = amount;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(TEXTURE, 0, 0, 12, 0, this.width, this.height);
        int mana = this.getScaledMana();
        Color manaColor = new Color(this.source.getColor());
        guiGraphics.setColor((float)manaColor.getRed() / 255.0f, (float)manaColor.getGreen() / 255.0f, (float)manaColor.getBlue() / 255.0f, 1.0f);
        guiGraphics.blit(TEXTURE, 1, 51 - mana, 1, 1, 10, mana);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(TEXTURE, 0, 0, 24, 0, this.width, this.height);
        guiGraphics.pose().popPose();
        if (this.isHoveredOrFocused()) {
            Component sourceText = this.source.getNameText();
            MutableComponent labelText = Component.translatable((String)"tooltip.primalmagick.source.mana_gauge", (Object[])new Object[]{sourceText, this.getManaText(), this.getMaxManaText()});
            GuiUtils.renderCustomTooltip(guiGraphics, Collections.singletonList(labelText), this.getX(), this.getY());
        }
    }

    protected int getScaledMana() {
        if (this.maxAmount == -1) {
            return 50;
        }
        if (this.maxAmount != 0 && this.curAmount != 0) {
            return this.curAmount * 50 / this.maxAmount;
        }
        return 0;
    }

    protected MutableComponent getManaText() {
        if (this.maxAmount == -1) {
            return Component.literal((String)Character.toString('\u221e'));
        }
        return Component.literal((String)MANA_FORMATTER.format((double)this.curAmount / 100.0));
    }

    public MutableComponent getMaxManaText() {
        if (this.maxAmount == -1) {
            return Component.literal((String)Character.toString('\u221e'));
        }
        return Component.literal((String)MANA_FORMATTER.format((double)this.maxAmount / 100.0));
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

