/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.client.gui.widgets.AbstractSourceWidget;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ManaCostWidget
extends AbstractSourceWidget {
    protected static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    protected final Supplier<ItemStack> wandStackSupplier;
    protected final Player player;

    public ManaCostWidget(Source source, int amount, int xIn, int yIn, Supplier<ItemStack> wandStackSupplier, Player player) {
        super(source, amount, xIn, yIn);
        this.wandStackSupplier = wandStackSupplier;
        this.player = player;
    }

    protected int getModifiedAmount() {
        int n;
        Minecraft mc = Minecraft.getInstance();
        ItemStack wandStack = this.wandStackSupplier.get();
        Item item = wandStack.getItem();
        if (item instanceof IWand) {
            IWand wand = (IWand)item;
            n = wand.getModifiedCost(wandStack, this.player, this.source, this.getAmount(), (HolderLookup.Provider)mc.level.registryAccess());
        } else {
            n = this.getAmount();
        }
        return n;
    }

    protected boolean hasModifiedAmount() {
        IWand wand;
        Minecraft mc = Minecraft.getInstance();
        ItemStack wandStack = this.wandStackSupplier.get();
        Item item = wandStack.getItem();
        return !(item instanceof IWand) || (wand = (IWand)item).containsMana(wandStack, this.player, this.source, this.getAmount(), (HolderLookup.Provider)mc.level.registryAccess());
    }

    @Override
    protected String getAmountString() {
        return ManaCostWidget.formatInWholeMana(this.getModifiedAmount());
    }

    protected static String formatInWholeMana(double amount) {
        return MANA_FORMATTER.format(amount / 100.0);
    }

    @Override
    protected int getAmountStringColor() {
        if (!this.hasModifiedAmount()) {
            return Color.RED.getRGB();
        }
        if (this.getModifiedAmount() < this.getAmount()) {
            return Color.GREEN.getRGB();
        }
        return super.getAmountStringColor();
    }

    @Override
    protected List<Component> getTooltipLines() {
        int baseCost = this.getAmount();
        int modifiedCost = this.getModifiedAmount();
        int costDelta = Math.abs(modifiedCost - baseCost);
        ImmutableList retVal = modifiedCost > baseCost ? ImmutableList.of((Object)Component.translatable((String)"label.primalmagick.crafting.mana.base", (Object[])new Object[]{ManaCostWidget.formatInWholeMana(baseCost)}), (Object)Component.translatable((String)"label.primalmagick.crafting.mana.penalty", (Object[])new Object[]{Component.literal((String)ManaCostWidget.formatInWholeMana(costDelta)).withStyle(ChatFormatting.RED)}), (Object)Component.translatable((String)"label.primalmagick.crafting.mana.modified", (Object[])new Object[]{ManaCostWidget.formatInWholeMana(modifiedCost), this.getSourceText()})) : (modifiedCost < baseCost ? ImmutableList.of((Object)Component.translatable((String)"label.primalmagick.crafting.mana.base", (Object[])new Object[]{ManaCostWidget.formatInWholeMana(baseCost)}), (Object)Component.translatable((String)"label.primalmagick.crafting.mana.bonus", (Object[])new Object[]{Component.literal((String)ManaCostWidget.formatInWholeMana(costDelta)).withStyle(ChatFormatting.GREEN)}), (Object)Component.translatable((String)"label.primalmagick.crafting.mana.modified", (Object[])new Object[]{ManaCostWidget.formatInWholeMana(modifiedCost), this.getSourceText()})) : Collections.singletonList(Component.translatable((String)"label.primalmagick.crafting.mana", (Object[])new Object[]{ManaCostWidget.formatInWholeMana(baseCost), this.getSourceText()})));
        return retVal;
    }
}

