/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EssenceCaskWidget
extends AbstractWidget {
    protected final int index;
    protected final EssenceType essenceType;
    protected final Source source;
    protected int amount;
    protected final BiConsumer<EssenceCaskWidget, Integer> onClick;

    public EssenceCaskWidget(int index, EssenceType type, Source source, int amount, int xIn, int yIn, BiConsumer<EssenceCaskWidget, Integer> onClick) {
        super(xIn, yIn, 16, 16, (Component)Component.empty());
        this.index = index;
        this.essenceType = type;
        this.source = source;
        this.amount = amount;
        this.onClick = onClick;
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = EssenceItem.getEssence(this.essenceType, this.source);
        List lines = stack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        lines.add(Component.translatable((String)"label.primalmagick.essence_cask.left_click").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        lines.add(Component.translatable((String)"label.primalmagick.essence_cask.right_click").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        this.setTooltip(Tooltip.create((Component)CommonComponents.joinLines((Collection)lines)));
    }

    public int getIndex() {
        return this.index;
    }

    public EssenceType getEssenceType() {
        return this.essenceType;
    }

    public Source getSource() {
        return this.source;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack tempStack = EssenceItem.getEssence(this.essenceType, this.source);
        GuiUtils.renderItemStack(guiGraphics, tempStack, this.getX(), this.getY(), this.getMessage().getString(), true);
        MutableComponent amountText = Component.literal((String)Integer.toString(this.amount));
        int width = mc.font.width((FormattedText)amountText);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 200.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        guiGraphics.drawString(mc.font, (Component)amountText, 0, 0, this.amount > 0 ? Color.WHITE.getRGB() : Color.RED.getRGB());
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickButton) {
        if (this.active && this.visible && this.clicked(mouseX, mouseY)) {
            this.onClick.accept(this, clickButton);
            return true;
        }
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }
}

