/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractSourceWidget
extends AbstractWidget {
    protected Source source;
    protected int amount;

    public AbstractSourceWidget(Source source, int amount, int xIn, int yIn) {
        super(xIn, yIn, 16, 16, (Component)Component.empty());
        this.source = source;
        this.amount = amount;
    }

    public Source getSource() {
        return this.source;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.getInstance();
        boolean discovered = this.source.isDiscovered((Player)mc.player);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.pose().scale(0.0625f, 0.0625f, 0.0625f);
        guiGraphics.blit(discovered ? this.source.getImage() : Source.getUnknownImage(), 0, 0, 0, 0, 255, 255);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        MutableComponent amountText = Component.literal((String)this.getAmountString());
        int width = mc.font.width(amountText.getString());
        guiGraphics.pose().translate((float)(this.getX() + 16 - width / 2), (float)(this.getY() + 12), 5.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
        guiGraphics.drawString(mc.font, (Component)amountText, 0, 0, this.getAmountStringColor());
        guiGraphics.pose().popPose();
        if (this.isHoveredOrFocused()) {
            GuiUtils.renderCustomTooltip(guiGraphics, this.getTooltipLines(), p_renderButton_1_, p_renderButton_2_);
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
    }

    protected String getAmountString() {
        return Integer.toString(this.getAmount());
    }

    protected int getAmountStringColor() {
        return Color.WHITE.getRGB();
    }

    protected Component getSourceText() {
        Minecraft mc = Minecraft.getInstance();
        boolean discovered = this.source.isDiscovered((Player)mc.player);
        return discovered ? this.source.getNameText() : Component.translatable((String)Source.getUnknownTranslationKey());
    }

    protected abstract List<Component> getTooltipLines();
}

