/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.scribe_table;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.client.gui.scribe_table.AbstractScribeTableScreen;
import com.verdantartifice.primalmagick.client.gui.widgets.VocabularyWidget;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.books.ScribeTableMode;
import com.verdantartifice.primalmagick.common.menus.ScribeStudyVocabularyMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.scribe_table.StudyVocabularyActionPacket;
import com.verdantartifice.primalmagick.common.tags.BookLanguageTagsPM;
import com.verdantartifice.primalmagick.common.util.PlayerUtils;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ScribeStudyVocabularyScreen
extends AbstractScribeTableScreen<ScribeStudyVocabularyMenu> {
    private static final ResourceLocation[] ENABLED_LEVEL_SPRITES = (ResourceLocation[])IntStream.rangeClosed(1, 10).mapToObj(arg_0 -> ScribeStudyVocabularyScreen.lambda$static$0("scribe_table/level_%d", arg_0)).map(ResourceUtils::loc).toArray(ResourceLocation[]::new);
    private static final ResourceLocation[] DISABLED_LEVEL_SPRITES = (ResourceLocation[])IntStream.rangeClosed(1, 10).mapToObj(arg_0 -> ScribeStudyVocabularyScreen.lambda$static$2("scribe_table/level_%d_disabled", arg_0)).map(ResourceUtils::loc).toArray(ResourceLocation[]::new);
    private static final ResourceLocation SLOT_DISABLED_SPRITE = ResourceUtils.loc("scribe_table/slot_disabled");
    private static final ResourceLocation SLOT_HIGHLIGHTED_SPRITE = ResourceUtils.loc("scribe_table/slot_highlighted");
    private static final ResourceLocation SLOT_SPRITE = ResourceUtils.loc("scribe_table/slot");
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/scribe_study_vocabulary.png");
    private static final ResourceLocation ENCHANTING_BOOK_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/enchanting_table_book.png");
    private final RandomSource random = RandomSource.create();
    private BookModel bookModel;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;
    protected VocabularyWidget vocabularyWidget;

    public ScribeStudyVocabularyScreen(ScribeStudyVocabularyMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    @Override
    protected ScribeTableMode getMode() {
        return ScribeTableMode.STUDY_VOCABULARY;
    }

    @Override
    protected ResourceLocation getBgTexture() {
        return TEXTURE;
    }

    @Override
    protected void init() {
        super.init();
        Holder.Reference<BookLanguage> lang = ((ScribeStudyVocabularyMenu)this.menu).getBookLanguage();
        this.vocabularyWidget = (VocabularyWidget)this.addRenderableWidget((GuiEventListener)new VocabularyWidget((Holder<BookLanguage>)lang, ((ScribeStudyVocabularyMenu)this.menu).getVocabularyCount(), this.leftPos + 35, this.topPos + 75));
        this.bookModel = new BookModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.BOOK));
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        this.tickBook();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int slotLeft = this.leftPos + 60;
        for (int slotIndex = 0; slotIndex < 3; ++slotIndex) {
            int slotTop = this.topPos + 42 + 19 * slotIndex;
            double dx = pMouseX - (double)slotLeft;
            double dy = pMouseY - (double)slotTop;
            if (!(dx >= 0.0) || !(dy >= 0.0) || !(dx < 108.0) || !(dy < 19.0) || !((ScribeStudyVocabularyMenu)this.menu).checkStudyClick((Player)this.minecraft.player, slotIndex)) continue;
            PacketHandler.sendToServer(new StudyVocabularyActionPacket(((ScribeStudyVocabularyMenu)this.menu).containerId, slotIndex));
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    @Override
    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int slotTop;
        int slotIndex;
        super.renderBg(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
        this.renderBook(pGuiGraphics, this.leftPos, this.topPos, pPartialTick);
        EnchantmentNames.getInstance().initSeed((long)((ScribeStudyVocabularyMenu)this.menu).getNameSeed());
        Holder.Reference<BookLanguage> activeLanguage = ((ScribeStudyVocabularyMenu)this.menu).getBookLanguage();
        this.vocabularyWidget.visible = activeLanguage.is(BookLanguageTagsPM.ANCIENT);
        this.vocabularyWidget.setLanguage((Holder<BookLanguage>)activeLanguage);
        this.vocabularyWidget.setAmount(((ScribeStudyVocabularyMenu)this.menu).getVocabularyCount());
        int slotLeft = this.leftPos + 60;
        int slotTextStart = slotLeft + 20;
        int hoveredSlotIndex = Integer.MIN_VALUE;
        for (slotIndex = 0; slotIndex < 3; ++slotIndex) {
            slotTop = this.topPos + 42 + 19 * slotIndex;
            int dx = pMouseX - slotLeft;
            int dy = pMouseY - slotTop;
            if (dx < 0 || dy < 0 || dx >= 108 || dy >= 19) continue;
            hoveredSlotIndex = slotIndex;
            break;
        }
        for (slotIndex = 0; slotIndex < 3; ++slotIndex) {
            slotTop = this.topPos + 42 + 19 * slotIndex;
            int cost = ((ScribeStudyVocabularyMenu)this.menu).costs[slotIndex];
            int minLevels = ((ScribeStudyVocabularyMenu)this.menu).minLevels[slotIndex];
            int textColor = 6839882;
            int textWidth = 86;
            if (cost <= 0) {
                pGuiGraphics.blitSprite(SLOT_DISABLED_SPRITE, slotLeft, slotTop, 108, 19);
                if (cost >= 0) continue;
                MutableComponent text = Component.translatable((String)"tooltip.primalmagick.scribe_table.button.study_vocabulary.already_studied");
                pGuiGraphics.drawString(this.font, (Component)text, slotLeft + 54 - this.font.width((FormattedText)text) / 2, slotTop + 5, (textColor & 0xFEFEFE) >> 1, false);
                continue;
            }
            String rawText = StringDecomposer.getPlainText((FormattedText)EnchantmentNames.getInstance().getRandomName(this.font, textWidth));
            FormattedText formattedText = this.font.getSplitter().headByWidth((FormattedText)Component.literal((String)rawText).withStyle(((BookLanguage)activeLanguage.value()).style()), textWidth, Style.EMPTY);
            int levelCount = ((ScribeStudyVocabularyMenu)this.menu).levelCostClues[slotIndex];
            if (!(this.minecraft.player.getAbilities().instabuild || this.minecraft.player.experienceLevel >= minLevels && PlayerUtils.canAffordXp((Player)this.minecraft.player, cost))) {
                pGuiGraphics.blitSprite(SLOT_DISABLED_SPRITE, slotLeft, slotTop, 108, 19);
                if (levelCount > 0 && levelCount <= DISABLED_LEVEL_SPRITES.length) {
                    pGuiGraphics.blitSprite(DISABLED_LEVEL_SPRITES[levelCount - 1], slotLeft + 1, slotTop + 1, 16, 16);
                }
                pGuiGraphics.drawWordWrap(this.font, formattedText, slotTextStart, slotTop + 2, textWidth, (textColor & 0xFEFEFE) >> 1);
            } else {
                if (slotIndex <= hoveredSlotIndex) {
                    pGuiGraphics.blitSprite(SLOT_HIGHLIGHTED_SPRITE, slotLeft, slotTop, 108, 19);
                    textColor = 0xFFFF80;
                } else {
                    pGuiGraphics.blitSprite(SLOT_SPRITE, slotLeft, slotTop, 108, 19);
                }
                if (levelCount > 0 && levelCount <= ENABLED_LEVEL_SPRITES.length) {
                    pGuiGraphics.blitSprite(ENABLED_LEVEL_SPRITES[levelCount - 1], slotLeft + 1, slotTop + 1, 16, 16);
                }
                pGuiGraphics.drawWordWrap(this.font, formattedText, slotTextStart, slotTop + 2, textWidth, textColor);
                textColor = 8453920;
            }
            if (minLevels <= 0) continue;
            String costStr = "" + minLevels;
            pGuiGraphics.drawString(this.font, costStr, slotTextStart + 86 - this.font.width(costStr), slotTop + 9, textColor);
        }
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        for (int slotIndex = 0; slotIndex < 3; ++slotIndex) {
            int cost = ((ScribeStudyVocabularyMenu)this.menu).costs[slotIndex];
            int minLevels = ((ScribeStudyVocabularyMenu)this.menu).minLevels[slotIndex];
            if (!this.isHovering(60, 42 + 19 * slotIndex, 108, 17, pMouseX, pMouseY) || cost <= 0) continue;
            int studyDelta = 0;
            for (int costIndex = 0; costIndex <= slotIndex && costIndex < ((ScribeStudyVocabularyMenu)this.menu).costs.length; ++costIndex) {
                if (((ScribeStudyVocabularyMenu)this.menu).costs[costIndex] <= 0) continue;
                ++studyDelta;
            }
            if (studyDelta <= 0) continue;
            Holder.Reference<BookLanguage> activeLanguage = ((ScribeStudyVocabularyMenu)this.menu).getBookLanguage();
            ArrayList<Object> tooltips = new ArrayList<Object>();
            tooltips.add(Component.translatable((String)"tooltip.primalmagick.scribe_table.button.study_vocabulary.study_count", (Object[])new Object[]{((BookLanguage)activeLanguage.value()).getName(), studyDelta}).withStyle(ChatFormatting.WHITE));
            if (!this.minecraft.player.getAbilities().instabuild) {
                tooltips.add(CommonComponents.EMPTY);
                ChatFormatting costColor = PlayerUtils.canAffordXp((Player)this.minecraft.player, cost) ? ChatFormatting.GRAY : ChatFormatting.RED;
                MutableComponent costLine = cost == 1 ? Component.translatable((String)"tooltip.primalmagick.experience.one") : Component.translatable((String)"tooltip.primalmagick.experience.many", (Object[])new Object[]{cost});
                tooltips.add(Component.translatable((String)"tooltip.primalmagick.scribe_table.button.study_vocabulary.experience_cost", (Object[])new Object[]{costLine}).withStyle(costColor));
                if (minLevels > 0) {
                    ChatFormatting levelColor = this.minecraft.player.experienceLevel < minLevels ? ChatFormatting.RED : ChatFormatting.GRAY;
                    tooltips.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{minLevels}).withStyle(levelColor));
                }
            }
            int totalNeeded = LinguisticsManager.getTotalRemainingVocabularyRequired((Player)this.minecraft.player, activeLanguage);
            int currentVocab = LinguisticsManager.getVocabulary((Player)this.minecraft.player, activeLanguage);
            if (currentVocab + studyDelta > totalNeeded) {
                tooltips.add(CommonComponents.EMPTY);
                tooltips.add(Component.translatable((String)"tooltip.primalmagick.scribe_table.button.study_vocabulary.no_more_needed").withStyle(ChatFormatting.RED));
            }
            pGuiGraphics.renderComponentTooltip(this.font, tooltips, pMouseX, pMouseY);
            break;
        }
    }

    private void renderBook(GuiGraphics pGuiGraphics, int pX, int pY, float pPartialTick) {
        float f = Mth.lerp((float)pPartialTick, (float)this.oOpen, (float)this.open);
        float f1 = Mth.lerp((float)pPartialTick, (float)this.oFlip, (float)this.flip);
        Lighting.setupForEntityInInventory();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)pX + 33.0f, (float)pY + 59.0f, 100.0f);
        float f2 = 40.0f;
        pGuiGraphics.pose().scale(-f2, f2, f2);
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(25.0f));
        pGuiGraphics.pose().translate((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, (1.0f - f) * 0.25f);
        float f3 = -(1.0f - f) * 90.0f - 90.0f;
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(f3));
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(180.0f));
        float f4 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float f5 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        this.bookModel.setupAnim(0.0f, f4, f5, f);
        VertexConsumer vertexconsumer = pGuiGraphics.bufferSource().getBuffer(this.bookModel.renderType(ENCHANTING_BOOK_LOCATION));
        this.bookModel.renderToBuffer(pGuiGraphics.pose(), vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, -1);
        pGuiGraphics.flush();
        pGuiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    public void tickBook() {
        ItemStack itemstack = ((ScribeStudyVocabularyMenu)this.menu).getSlot(0).getItem();
        if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.time;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            if (((ScribeStudyVocabularyMenu)this.menu).costs[i] == 0) continue;
            flag = true;
        }
        this.open = flag ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.clamp((float)this.open, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        float f = 0.2f;
        f1 = Mth.clamp((float)f1, (float)(-f), (float)f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }

    private static /* synthetic */ String lambda$static$2(String rec$, Object xva$0) {
        return "scribe_table/level_%d_disabled".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return "scribe_table/level_%d".formatted(xva$0);
    }
}

