/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.scribe_table;

import com.verdantartifice.primalmagick.client.gui.scribe_table.AbstractScribeTableScreen;
import com.verdantartifice.primalmagick.client.gui.widgets.VocabularyWidget;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.books.ScribeTableMode;
import com.verdantartifice.primalmagick.common.books.grids.GridDefinition;
import com.verdantartifice.primalmagick.common.books.grids.GridNodeDefinition;
import com.verdantartifice.primalmagick.common.books.grids.PlayerGrid;
import com.verdantartifice.primalmagick.common.menus.ScribeGainComprehensionMenu;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.tags.BookLanguageTagsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector2i;

public class ScribeGainComprehensionScreen
extends AbstractScribeTableScreen<ScribeGainComprehensionMenu> {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/scribe_gain_comprehension.png");
    protected static final ResourceLocation PARCHMENT_SPRITE = ResourceUtils.loc("scribe_table/parchment");
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Map<Vector2i, NodeButton> nodeButtons = new HashMap<Vector2i, NodeButton>();
    protected VocabularyWidget vocabularyWidget;
    protected PlayerGrid grid;
    protected long nextCheckTime = 0L;

    public ScribeGainComprehensionScreen(ScribeGainComprehensionMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    @Override
    protected ScribeTableMode getMode() {
        return ScribeTableMode.GAIN_COMPREHENSION;
    }

    @Override
    protected ResourceLocation getBgTexture() {
        return TEXTURE;
    }

    @Override
    protected void init() {
        super.init();
        Holder.Reference<BookLanguage> lang = ((ScribeGainComprehensionMenu)this.menu).getBookLanguage();
        this.vocabularyWidget = (VocabularyWidget)this.addRenderableWidget((GuiEventListener)new VocabularyWidget((Holder<BookLanguage>)lang, ((ScribeGainComprehensionMenu)this.menu).getVocabularyCount(), this.leftPos + 151, this.topPos + 17));
        this.grid = LinguisticsManager.getPlayerGrid((Player)this.minecraft.player, lang.key().location());
        for (int y = 0; y <= 7; ++y) {
            for (int x = 0; x <= 7; ++x) {
                Vector2i nodePos = new Vector2i(x, y);
                NodeButton button = new NodeButton(this, x, y, this.leftPos + 40 + 12 * x, this.topPos + 23 + 12 * y);
                button.visible = false;
                this.nodeButtons.put(nodePos, button);
                this.addRenderableWidget((GuiEventListener)button);
            }
        }
    }

    @Override
    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        boolean timeUp;
        super.renderBg(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
        Holder.Reference<BookLanguage> lang = ((ScribeGainComprehensionMenu)this.menu).getBookLanguage();
        this.vocabularyWidget.visible = lang.is(BookLanguageTagsPM.ANCIENT);
        this.vocabularyWidget.setLanguage((Holder<BookLanguage>)lang);
        this.vocabularyWidget.setAmount(((ScribeGainComprehensionMenu)this.menu).getVocabularyCount());
        boolean bl = timeUp = System.currentTimeMillis() > this.nextCheckTime;
        if (this.grid == null || !lang.key().equals(this.grid.getDefinition().getLanguage()) || timeUp) {
            this.refreshGrid();
            this.nextCheckTime = System.currentTimeMillis() + 250L;
        }
        if (((BookLanguage)lang.value()).isComplex()) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate((float)(this.leftPos + 31), (float)(this.topPos + 17), 0.0f);
            pGuiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            pGuiGraphics.blitSprite(PARCHMENT_SPRITE, 0, 0, 228, 216);
            pGuiGraphics.pose().popPose();
            if (this.grid != null) {
                this.nodeButtons.entrySet().forEach(entry -> {
                    Vector2i nodePos = (Vector2i)entry.getKey();
                    NodeButton button = (NodeButton)((Object)((Object)entry.getValue()));
                    if (this.grid.getDefinition().getNodes().keySet().contains(nodePos)) {
                        boolean unlockable = this.grid.isUnlockable(nodePos);
                        boolean isUnlocked = this.grid.getUnlocked().contains(nodePos);
                        button.setGridDefinition(this.grid.getDefinition());
                        button.setReachable(unlockable || isUnlocked);
                        button.setUnlockable(unlockable);
                        button.active = !isUnlocked;
                        button.visible = true;
                    } else {
                        button.visible = false;
                    }
                });
            } else {
                this.nodeButtons.entrySet().stream().map(e -> (NodeButton)((Object)((Object)e.getValue()))).forEach(b -> {
                    b.visible = false;
                });
            }
        } else {
            MutableComponent text = Component.translatable((String)"label.primalmagick.scribe_table.missing_book");
            int width = this.minecraft.font.width(text.getString());
            Font font = this.minecraft.font;
            int n = this.leftPos + 7 + (162 - width) / 2;
            Objects.requireNonNull(this.minecraft.font);
            pGuiGraphics.drawString(font, (Component)text, n, this.topPos + 7 + (128 - 9) / 2, Color.BLACK.getRGB(), false);
            this.nodeButtons.entrySet().stream().map(e -> (NodeButton)((Object)((Object)e.getValue()))).forEach(b -> {
                b.visible = false;
            });
        }
    }

    protected void refreshGrid() {
        Holder.Reference<BookLanguage> lang = ((ScribeGainComprehensionMenu)this.menu).getBookLanguage();
        PlayerGrid newGrid = LinguisticsManager.getPlayerGrid((Player)this.minecraft.player, lang.key().location());
        if (this.grid == null || newGrid == null || newGrid.getLastModified() > this.grid.getLastModified() || !this.grid.getDefinition().getLanguage().equals(newGrid.getDefinition().getLanguage())) {
            this.grid = newGrid;
        }
    }

    protected static class NodeButton
    extends ImageButton {
        protected static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(ResourceUtils.loc("scribe_table/grid_node_button"), ResourceUtils.loc("scribe_table/grid_node_button_disabled"), ResourceUtils.loc("scribe_table/grid_node_button_highlighted"), ResourceUtils.loc("scribe_table/grid_node_button_disabled_highlighted"));
        protected static final ResourceLocation PLACEHOLDER = ResourceUtils.loc("scribe_table/grid_node_placeholder");
        protected final Player player;
        protected final RegistryAccess registryAccess;
        protected final int xIndex;
        protected final int yIndex;
        protected Optional<GridDefinition> gridDef;
        protected boolean reachable;
        protected boolean unlockable;
        protected Component lastTooltip = Component.empty();
        protected Component tooltip = Component.empty();

        public NodeButton(ScribeGainComprehensionScreen screen, int xIndex, int yIndex, int leftPos, int topPos) {
            super(leftPos, topPos, 12, 12, BUTTON_SPRITES, button -> {
                ClientLevel level = ((ScribeGainComprehensionScreen)screen).minecraft.level;
                screen.grid.unlock(xIndex, yIndex, level.registryAccess());
                level.playSound((Player)((ScribeGainComprehensionScreen)screen).minecraft.player, ((ScribeGainComprehensionMenu)screen.menu).getTilePos(), SoundsPM.WRITING.get(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
            });
            this.player = ((ScribeGainComprehensionScreen)screen).minecraft.player;
            this.registryAccess = ((ScribeGainComprehensionScreen)screen).minecraft.level.registryAccess();
            this.gridDef = screen.grid == null ? Optional.empty() : Optional.ofNullable(screen.grid.getDefinition());
            this.xIndex = xIndex;
            this.yIndex = yIndex;
            this.reachable = false;
            this.unlockable = false;
        }

        public void setReachable(boolean reachable) {
            this.reachable = reachable;
        }

        public void setUnlockable(boolean unlockable) {
            this.unlockable = unlockable;
        }

        public void setGridDefinition(GridDefinition gridDef) {
            this.gridDef = Optional.ofNullable(gridDef);
        }

        public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            this.lastTooltip = this.tooltip;
            MutableObject mutableTooltip = new MutableObject((Object)Component.empty());
            this.gridDef.ifPresent(def -> def.getNode(this.xIndex, this.yIndex).ifPresent(node -> {
                Component rewardText = node.getReward().getDescription(this.player, this.registryAccess);
                if (this.isActive()) {
                    ArrayList<Object> lines = new ArrayList<Object>();
                    lines.add(Component.translatable((String)"tooltip.primalmagick.scribe_table.grid.reward", (Object[])new Object[]{rewardText}));
                    if (!this.player.getAbilities().instabuild) {
                        lines.add(CommonComponents.EMPTY);
                        Holder.Reference<BookLanguage> lang = BookLanguagesPM.getLanguageOrDefault(def.getLanguage(), this.registryAccess, BookLanguagesPM.DEFAULT);
                        MutableComponent costText = Component.translatable((String)"tooltip.primalmagick.scribe_table.grid.cost", (Object[])new Object[]{node.getVocabularyCost(), ((BookLanguage)lang.value()).getName()});
                        if (LinguisticsManager.getVocabulary(this.player, lang) < node.getVocabularyCost()) {
                            costText = costText.withStyle(ChatFormatting.RED);
                        }
                        lines.add(costText);
                    }
                    if (!this.reachable) {
                        lines.add(CommonComponents.EMPTY);
                        lines.add(Component.translatable((String)"tooltip.primalmagick.scribe_table.grid.no_path").withStyle(ChatFormatting.RED));
                    }
                    mutableTooltip.setValue((Object)CommonComponents.joinLines(lines));
                } else {
                    mutableTooltip.setValue((Object)Component.translatable((String)"tooltip.primalmagick.scribe_table.grid.reward.unlocked", (Object[])new Object[]{rewardText}));
                }
            }));
            this.tooltip = (Component)mutableTooltip.getValue();
            if (!this.lastTooltip.equals((Object)this.tooltip)) {
                this.setTooltip(Tooltip.create((Component)this.tooltip));
            }
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
            pGuiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            ResourceLocation resourcelocation = this.reachable ? this.sprites.get(this.isActive(), this.isHoveredOrFocused()) : PLACEHOLDER;
            pGuiGraphics.blitSprite(resourcelocation, 0, 0, this.width * 2, this.height * 2);
            pGuiGraphics.pose().popPose();
            this.gridDef.flatMap(d -> d.getNode(this.xIndex, this.yIndex)).ifPresent(node -> {
                pGuiGraphics.pose().pushPose();
                int dx = this.width / 2;
                int dy = this.height / 2;
                pGuiGraphics.pose().translate((float)(this.getX() + 2) + (float)dx * 0.75f, (float)(this.getY() + 2) + (float)dy * 0.75f, 5.0f);
                pGuiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
                if (this.unlockable) {
                    float scale = 1.0f + 0.1f * Mth.sin((float)(((float)this.player.tickCount + pPartialTick) / 3.0f));
                    pGuiGraphics.pose().scale(scale, scale, 1.0f);
                }
                pGuiGraphics.blit(node.getReward().getIconLocation(this.player), (int)((double)(-dx) * 1.5), (int)((double)(-dy) * 1.5), 0, 0.0f, 0.0f, 16, 16, 16, 16);
                pGuiGraphics.pose().popPose();
                node.getReward().getAmountText().ifPresent(text -> {
                    pGuiGraphics.pose().pushPose();
                    Minecraft mc = Minecraft.getInstance();
                    int width = mc.font.width(text.getString());
                    pGuiGraphics.pose().translate((float)(this.getX() + 11 - width / 2), (float)(this.getY() + 7), 10.0f);
                    pGuiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
                    pGuiGraphics.drawString(mc.font, text, 0, 0, Color.WHITE.getRGB());
                    pGuiGraphics.pose().popPose();
                });
            });
        }

        protected boolean clicked(double pMouseX, double pMouseY) {
            boolean retVal;
            boolean bl = retVal = this.reachable && super.clicked(pMouseX, pMouseY);
            if (retVal && this.gridDef.isPresent()) {
                Optional<GridNodeDefinition> nodeOpt = this.gridDef.get().getNode(this.xIndex, this.yIndex);
                Holder.Reference<BookLanguage> lang = BookLanguagesPM.getLanguageOrDefault(this.gridDef.get().getLanguage(), this.registryAccess, BookLanguagesPM.DEFAULT);
                return nodeOpt.isPresent() && (this.player.getAbilities().instabuild || LinguisticsManager.getVocabulary(this.player, lang) >= nodeOpt.get().getVocabularyCost());
            }
            return false;
        }
    }
}

