/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class OverlayArcaneRecipeComponent
implements Renderable,
GuiEventListener {
    private static final ResourceLocation OVERLAY_RECIPE_SPRITE = ResourceLocation.withDefaultNamespace((String)"recipe_book/overlay_recipe");
    protected static final WidgetSprites CRAFTING_OVERLAY_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/crafting_overlay"), ResourceLocation.withDefaultNamespace((String)"recipe_book/crafting_overlay_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/crafting_overlay_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/crafting_overlay_disabled_highlighted"));
    protected static final WidgetSprites FURNACE_OVERLAY_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_overlay"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_overlay_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_overlay_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_overlay_disabled_highlighted"));
    protected static final int MAX_ROW = 4;
    protected static final int MAX_ROW_LARGE = 5;
    protected static final float ITEM_RENDER_SCALE = 0.375f;
    protected final List<OverlayArcaneRecipeButton> recipeButtons = new ArrayList<OverlayArcaneRecipeButton>();
    protected boolean isVisible;
    protected int x;
    protected int y;
    protected Minecraft mc;
    protected ArcaneRecipeCollection collection;
    @Nullable
    protected RecipeHolder<?> lastRecipeClicked;
    protected float time;
    protected boolean useFurnaceStyle;

    public void init(Minecraft mc, ArcaneRecipeCollection recipeCollection, ArcaneRecipeBook book, int xPos, int yPos, int dx, int dy, float parentWidth) {
        float f5;
        float f4;
        float f3;
        float f2;
        this.mc = mc;
        this.collection = recipeCollection;
        boolean isFiltering = false;
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        if (abstractContainerMenu instanceof IArcaneRecipeBookMenu) {
            IArcaneRecipeBookMenu arcaneMenu = (IArcaneRecipeBookMenu)abstractContainerMenu;
            this.useFurnaceStyle = arcaneMenu.isSingleIngredientMenu();
            isFiltering = book.isFiltering(arcaneMenu.getRecipeBookType());
        } else {
            this.useFurnaceStyle = false;
        }
        List<RecipeHolder<?>> visibleRecipes = this.collection.getDisplayRecipes(true);
        List invisibleRecipes = isFiltering ? Collections.emptyList() : this.collection.getDisplayRecipes(false);
        int visibleSize = visibleRecipes.size();
        int totalSize = visibleSize + invisibleRecipes.size();
        int maxRowSize = totalSize <= 16 ? 4 : 5;
        int rowCount = Mth.ceil((double)((float)totalSize / (float)maxRowSize));
        this.x = xPos;
        this.y = yPos;
        float f = this.x + Math.min(totalSize, maxRowSize) * 25;
        float f1 = dx + 50;
        if (f > f1) {
            this.x = (int)((float)this.x - parentWidth * (float)((int)((f - f1) / parentWidth)));
        }
        if ((f2 = (float)(this.y + rowCount * 25)) > (f3 = (float)(dy + 50))) {
            this.y = (int)((float)this.y - parentWidth * (float)Mth.ceil((float)((f2 - f3) / parentWidth)));
        }
        if ((f4 = (float)this.y) < (f5 = (float)(dy - 100))) {
            this.y = (int)((float)this.y - parentWidth * (float)Mth.ceil((float)((f4 - f5) / parentWidth)));
        }
        this.isVisible = true;
        this.recipeButtons.clear();
        for (int index = 0; index < totalSize; ++index) {
            boolean isVisible = index < visibleSize;
            RecipeHolder recipe = isVisible ? visibleRecipes.get(index) : (RecipeHolder)invisibleRecipes.get(index - visibleSize);
            int slotX = this.x + 4 + 25 * (index % maxRowSize);
            int slotY = this.y + 5 + 25 * (index / maxRowSize);
            if (this.useFurnaceStyle) {
                this.recipeButtons.add(new OverlayArcaneSingleIngredientRecipeButton(this, slotX, slotY, recipe, isVisible));
                continue;
            }
            this.recipeButtons.add(new OverlayArcaneRecipeButton(slotX, slotY, recipe, isVisible));
        }
        this.lastRecipeClicked = null;
    }

    public ArcaneRecipeCollection getRecipeCollection() {
        return this.collection;
    }

    @Nullable
    public RecipeHolder<?> getLastRecipeClicked() {
        return this.lastRecipeClicked;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        for (OverlayArcaneRecipeButton recipeButton : this.recipeButtons) {
            if (!recipeButton.mouseClicked(mouseX, mouseY, button)) continue;
            this.lastRecipeClicked = recipeButton.recipe;
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible) {
            this.time += partialTicks;
            RenderSystem.enableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0, 0.0, 170.0);
            int maxRowSize = this.recipeButtons.size() <= 16 ? 4 : 5;
            int colCount = Math.min(this.recipeButtons.size(), maxRowSize);
            int rowCount = Mth.ceil((float)((float)this.recipeButtons.size() / (float)maxRowSize));
            guiGraphics.blitSprite(OVERLAY_RECIPE_SPRITE, this.x, this.y, colCount * 25 + 8, rowCount * 25 + 8);
            RenderSystem.disableBlend();
            for (OverlayArcaneRecipeButton recipeButton : this.recipeButtons) {
                recipeButton.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
            guiGraphics.pose().popPose();
        }
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setFocused(boolean p_265728_) {
    }

    public boolean isFocused() {
        return false;
    }

    protected class OverlayArcaneSingleIngredientRecipeButton
    extends OverlayArcaneRecipeButton {
        public OverlayArcaneSingleIngredientRecipeButton(OverlayArcaneRecipeComponent this$0, int xPos, int yPos, RecipeHolder<?> recipe, boolean isCraftable) {
            super(xPos, yPos, recipe, isCraftable);
        }

        protected void calculateIngredientsPositions(Recipe<?> recipe) {
            ItemStack[] aitemstack = ((Ingredient)recipe.getIngredients().get(0)).getItems();
            this.ingredientPos.add(new OverlayArcaneRecipeButton.Pos(this, 10, 10, aitemstack));
        }
    }

    protected class OverlayArcaneRecipeButton
    extends AbstractWidget
    implements PlaceRecipe<Ingredient> {
        protected final RecipeHolder<?> recipe;
        protected final boolean isCraftable;
        protected final List<Pos> ingredientPos;

        public OverlayArcaneRecipeButton(int xPos, int yPos, RecipeHolder<?> recipe, boolean isCraftable) {
            super(xPos, yPos, 200, 20, (Component)Component.empty());
            this.ingredientPos = new ArrayList<Pos>();
            this.width = 24;
            this.height = 24;
            this.recipe = recipe;
            this.isCraftable = isCraftable;
            this.calculateIngredientsPositions(recipe);
        }

        protected void calculateIngredientsPositions(RecipeHolder<?> recipe) {
            this.placeRecipe(3, 3, -1, recipe, recipe.value().getIngredients().iterator(), 0);
        }

        public void updateWidgetNarration(NarrationElementOutput output) {
            this.defaultButtonNarrationText(output);
        }

        public void addItemToSlot(Ingredient ingredient, int pSlot, int pMaxAmount, int pX, int pY) {
            ItemStack[] stackArray = ingredient.getItems();
            if (stackArray.length != 0) {
                this.ingredientPos.add(new Pos(this, 3 + pY * 7, 3 + pX * 7, stackArray));
            }
        }

        public void renderWidget(GuiGraphics guiGraphics, int p_93677_, int p_93678_, float p_93679_) {
            WidgetSprites sprites = OverlayArcaneRecipeComponent.this.useFurnaceStyle ? FURNACE_OVERLAY_SPRITES : CRAFTING_OVERLAY_SPRITES;
            ResourceLocation spriteLoc = sprites.get(this.isCraftable, this.isHoveredOrFocused());
            guiGraphics.blitSprite(spriteLoc, this.getX(), this.getY(), this.width, this.height);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)(this.getX() + 2), (double)(this.getY() + 2), 125.0);
            for (Pos pos : this.ingredientPos) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((double)pos.x, (double)pos.y, 0.0);
                guiGraphics.pose().scale(0.375f, 0.375f, 1.0f);
                guiGraphics.pose().translate(-8.0, -8.0, 0.0);
                RenderSystem.applyModelViewMatrix();
                guiGraphics.renderItem(pos.ingredients[Mth.floor((float)(OverlayArcaneRecipeComponent.this.time / 30.0f)) % pos.ingredients.length], 0, 0);
                guiGraphics.pose().popPose();
            }
            guiGraphics.pose().popPose();
        }

        protected class Pos {
            public final ItemStack[] ingredients;
            public final int x;
            public final int y;

            public Pos(OverlayArcaneRecipeButton this$1, int x, int y, ItemStack[] ingredients) {
                this.ingredients = ingredients;
                this.x = x;
                this.y = y;
            }
        }
    }
}

