/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ArcaneRecipeCollection {
    protected final RegistryAccess registryAccess;
    protected final List<RecipeHolder<?>> recipes;
    protected final boolean singleResultItem;
    protected final Set<RecipeHolder<?>> craftable = new HashSet();
    protected final Set<RecipeHolder<?>> fitsDimensions = new HashSet();
    protected final Set<RecipeHolder<?>> known = new HashSet();

    public ArcaneRecipeCollection(RegistryAccess registryAccess, List<RecipeHolder<?>> recipes) {
        this.registryAccess = registryAccess;
        this.recipes = ImmutableList.copyOf(recipes);
        this.singleResultItem = recipes.size() <= 1 ? true : ArcaneRecipeCollection.allRecipesHaveSameResult(registryAccess, recipes);
    }

    public ArcaneRecipeCollection(RecipeCollection vanillaCollection) {
        this.registryAccess = vanillaCollection.registryAccess();
        this.recipes = ImmutableList.copyOf((Collection)vanillaCollection.getRecipes());
        this.singleResultItem = vanillaCollection.hasSingleResultItem();
    }

    protected static boolean allRecipesHaveSameResult(RegistryAccess registryAccess, List<RecipeHolder<?>> recipeHolders) {
        ItemStack referenceStack = recipeHolders.get(0).value().getResultItem((HolderLookup.Provider)registryAccess);
        for (int index = 1; index < recipeHolders.size(); ++index) {
            ItemStack stack = recipeHolders.get(index).value().getResultItem((HolderLookup.Provider)registryAccess);
            if (ItemStack.isSameItemSameComponents((ItemStack)referenceStack, (ItemStack)stack)) continue;
            return false;
        }
        return true;
    }

    public boolean hasKnownRecipes() {
        return !this.known.isEmpty();
    }

    public void updateKnownRecipes(RecipeBook vanillaBook, ArcaneRecipeBook arcaneBook) {
        for (RecipeHolder<?> recipe : this.recipes) {
            if (!vanillaBook.contains(recipe) && !arcaneBook.contains(recipe)) continue;
            this.known.add(recipe);
        }
    }

    public void canCraft(StackedContents contents, int gridWidth, int gridHeight, RecipeBook vanillaBook, ArcaneRecipeBook arcaneBook) {
        for (RecipeHolder<?> recipe : this.recipes) {
            boolean flag;
            boolean bl = flag = recipe.value().canCraftInDimensions(gridWidth, gridHeight) && (vanillaBook.contains(recipe) || arcaneBook.contains(recipe));
            if (flag) {
                this.fitsDimensions.add(recipe);
            } else {
                this.fitsDimensions.remove(recipe);
            }
            if (flag && contents.canCraft(recipe.value(), null)) {
                this.craftable.add(recipe);
                continue;
            }
            this.craftable.remove(recipe);
        }
    }

    public boolean isCraftable(RecipeHolder<?> recipe) {
        return this.craftable.contains(recipe);
    }

    public boolean hasCraftable() {
        return !this.craftable.isEmpty();
    }

    public boolean hasFitting() {
        return !this.fitsDimensions.isEmpty();
    }

    public List<RecipeHolder<?>> getRecipes() {
        return this.recipes;
    }

    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public List<RecipeHolder<?>> getRecipes(boolean isCraftable) {
        ArrayList retVal = new ArrayList();
        Set<RecipeHolder<?>> set = isCraftable ? this.craftable : this.fitsDimensions;
        for (RecipeHolder<?> recipe : this.recipes) {
            if (!set.contains(recipe)) continue;
            retVal.add(recipe);
        }
        return retVal;
    }

    public List<RecipeHolder<?>> getDisplayRecipes(boolean isCraftable) {
        ArrayList retVal = new ArrayList();
        for (RecipeHolder<?> recipe : this.recipes) {
            if (!this.fitsDimensions.contains(recipe) || this.craftable.contains(recipe) != isCraftable) continue;
            retVal.add(recipe);
        }
        return retVal;
    }

    public boolean hasSingleResultItem() {
        return this.singleResultItem;
    }

    public int hashCode() {
        return this.recipes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArcaneRecipeCollection other = (ArcaneRecipeCollection)obj;
        return this.recipes.equals(other.getRecipes());
    }
}

