/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeBookPage;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ArcaneRecipeButton
extends AbstractWidget {
    protected static final WidgetSprites SLOT_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_craftable"), ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_uncraftable"), ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_many_craftable"), ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_many_uncraftable"));
    protected static final float ANIMATION_TIME = 15.0f;
    protected static final int BACKGROUND_SIZE = 25;
    public static final int TICKS_TO_SWAP = 30;
    protected static final Component MORE_RECIPES_TOOLTIP = Component.translatable((String)"gui.recipebook.moreRecipes");
    protected IArcaneRecipeBookMenu<?, ?> menu;
    protected ArcaneRecipeBook book;
    protected ArcaneRecipeCollection collection;
    protected float time;
    protected float animationTime;
    protected int currentIndex;

    public ArcaneRecipeButton() {
        super(0, 0, 25, 25, (Component)Component.empty());
    }

    public void init(ArcaneRecipeCollection recipeCollection, ArcaneRecipeBookPage page) {
        IArcaneRecipeBookMenu recipeBookMenu;
        Minecraft mc = page.getMinecraft();
        this.collection = recipeCollection;
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        this.menu = abstractContainerMenu instanceof IArcaneRecipeBookMenu ? (recipeBookMenu = (IArcaneRecipeBookMenu)abstractContainerMenu) : null;
        this.book = page.getArcaneRecipeBook();
        List<RecipeHolder<?>> list = this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType()));
        for (RecipeHolder recipeHolder : list) {
            if (!this.book.willHighlight(recipeHolder)) continue;
            page.recipesShown(list);
            this.animationTime = 15.0f;
            break;
        }
    }

    public ArcaneRecipeCollection getCollection() {
        return this.collection;
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_93677_, int p_93678_, float p_93679_) {
        boolean animating;
        if (!Screen.hasControlDown()) {
            this.time += p_93679_;
        }
        Minecraft mc = Minecraft.getInstance();
        boolean bl = animating = this.animationTime > 0.0f;
        if (animating) {
            float scale = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((double)(this.getX() + 8), (double)(this.getY() + 12), 0.0);
            guiGraphics.pose().scale(scale, scale, 1.0f);
            guiGraphics.pose().translate((double)(-(this.getX() + 8)), (double)(-(this.getY() + 12)), 0.0);
            this.animationTime -= p_93679_;
        }
        ResourceLocation spriteLoc = SLOT_SPRITES.get(this.collection.hasCraftable(), this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType())).size() > 1);
        guiGraphics.blitSprite(spriteLoc, this.getX(), this.getY(), this.width, this.height);
        List<RecipeHolder<?>> recipeList = this.getOrderedRecipes();
        this.currentIndex = Mth.floor((float)(this.time / 30.0f)) % recipeList.size();
        ItemStack stack = recipeList.get(this.currentIndex).value().getResultItem((HolderLookup.Provider)mc.level.registryAccess());
        int k = 4;
        if (this.collection.hasSingleResultItem() && this.getOrderedRecipes().size() > 1) {
            guiGraphics.renderItem(stack, this.getX() + k + 1, this.getY() + k + 1, 0, 10);
            --k;
        }
        guiGraphics.renderFakeItem(stack, this.getX() + k, this.getY() + k);
        if (animating) {
            guiGraphics.pose().popPose();
        }
    }

    protected List<RecipeHolder<?>> getOrderedRecipes() {
        List<RecipeHolder<?>> retVal = this.collection.getDisplayRecipes(true);
        if (!this.book.isFiltering(this.menu.getRecipeBookType())) {
            retVal.addAll(this.collection.getDisplayRecipes(false));
        }
        return retVal;
    }

    public boolean isOnlyOption() {
        return this.getOrderedRecipes().size() == 1;
    }

    public RecipeHolder<?> getRecipe() {
        return this.getOrderedRecipes().get(this.currentIndex);
    }

    public List<Component> getTooltipText(Screen screen) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = this.getRecipe().value().getResultItem((HolderLookup.Provider)mc.level.registryAccess());
        ArrayList<Component> retVal = new ArrayList<Component>(Screen.getTooltipFromItem((Minecraft)mc, (ItemStack)stack));
        if (this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType())).size() > 1) {
            retVal.add(MORE_RECIPES_TOOLTIP);
        }
        return retVal;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = this.getRecipe().value().getResultItem((HolderLookup.Provider)mc.level.registryAccess());
        output.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"narration.recipe", (Object[])new Object[]{stack.getHoverName()}));
        if (this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType())).size() > 1) {
            output.add(NarratedElementType.USAGE, new Component[]{Component.translatable((String)"narration.button.usage.hovered"), Component.translatable((String)"narration.recipe.usage.more")});
        } else {
            output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.button.usage.hovered"));
        }
    }

    public int getWidth() {
        return 25;
    }

    protected boolean isValidClickButton(int value) {
        return value == 0 || value == 1;
    }
}

