/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.client.recipe_book.ArcaneRecipeBookCategories;
import com.verdantartifice.primalmagick.client.recipe_book.ClientArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ArcaneRecipeBookTabButton
extends StateSwitchingButton {
    protected static final float ANIMATION_TIME_TOTAL = 15.0f;
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/tab"), ResourceLocation.withDefaultNamespace((String)"recipe_book/tab_selected"));
    protected final ArcaneRecipeBookCategories category;
    protected float animationTime;

    public ArcaneRecipeBookTabButton(ArcaneRecipeBookCategories category) {
        super(0, 0, 35, 27, false);
        this.category = category;
        this.initTextureValues(SPRITES);
    }

    public void startAnimation(Minecraft mc, ClientRecipeBook vanillaBook, ClientArcaneRecipeBook arcaneBook) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(arcaneBook.getCollection(this.category));
        builder.addAll((Iterable)vanillaBook.getCollection(this.category.getVanillaCategory()).stream().map(ArcaneRecipeCollection::new).collect(Collectors.toList()));
        ImmutableList list = builder.build();
        AbstractContainerMenu abstractContainerMenu = mc.player.containerMenu;
        if (abstractContainerMenu instanceof IArcaneRecipeBookMenu) {
            IArcaneRecipeBookMenu recipeMenu = (IArcaneRecipeBookMenu)abstractContainerMenu;
            for (ArcaneRecipeCollection recipeCollection : list) {
                for (RecipeHolder<?> recipe : recipeCollection.getRecipes(arcaneBook.getData().isFiltering(recipeMenu.getRecipeBookType()))) {
                    if (!arcaneBook.getData().willHighlight(recipe) && !vanillaBook.willHighlight(recipe)) continue;
                    this.animationTime = 15.0f;
                    return;
                }
            }
        }
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.sprites != null) {
            if (this.animationTime > 0.0f) {
                float f = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
                pGuiGraphics.pose().pushPose();
                pGuiGraphics.pose().translate((double)(this.getX() + 8), (double)(this.getY() + 12), 0.0);
                pGuiGraphics.pose().scale(1.0f, f, 1.0f);
                pGuiGraphics.pose().translate((double)(-(this.getX() + 8)), (double)(-(this.getY() + 12)), 0.0);
            }
            Minecraft mc = Minecraft.getInstance();
            RenderSystem.disableDepthTest();
            ResourceLocation spriteLoc = this.sprites.get(true, this.isStateTriggered);
            int x = this.getX();
            if (this.isStateTriggered) {
                x -= 2;
            }
            pGuiGraphics.blitSprite(spriteLoc, x, this.getY(), this.width, this.height);
            RenderSystem.enableDepthTest();
            this.renderIcon(pGuiGraphics, mc.getItemRenderer());
            if (this.animationTime > 0.0f) {
                pGuiGraphics.pose().popPose();
                this.animationTime -= pPartialTick;
            }
        }
    }

    protected void renderIcon(GuiGraphics guiGraphics, ItemRenderer pItemRenderer) {
        int dx;
        List<ItemStack> list = this.category.getIconItems();
        int n = dx = this.isStateTriggered ? -2 : 0;
        if (list.size() == 1) {
            guiGraphics.renderFakeItem(list.get(0), this.getX() + 9 + dx, this.getY() + 5);
        } else if (list.size() == 2) {
            guiGraphics.renderFakeItem(list.get(0), this.getX() + 3 + dx, this.getY() + 5);
            guiGraphics.renderFakeItem(list.get(1), this.getX() + 14 + dx, this.getY() + 5);
        }
    }

    public ArcaneRecipeBookCategories getCategory() {
        return this.category;
    }

    public boolean updateVisibility(ClientRecipeBook vanillaBook, ClientArcaneRecipeBook arcaneBook) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(arcaneBook.getCollection(this.category));
        builder.addAll((Iterable)vanillaBook.getCollection(this.category.getVanillaCategory()).stream().map(ArcaneRecipeCollection::new).collect(Collectors.toList()));
        ImmutableList list = builder.build();
        this.visible = false;
        for (ArcaneRecipeCollection collection : list) {
            if (!collection.hasKnownRecipes() || !collection.hasFitting()) continue;
            this.visible = true;
            break;
        }
        return this.visible;
    }
}

