/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeBookPage;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeBookTabButton;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.client.recipe_book.ArcaneRecipeBookCategories;
import com.verdantartifice.primalmagick.client.recipe_book.ArcaneSearchRegistry;
import com.verdantartifice.primalmagick.client.recipe_book.ClientArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.StackedComponentContents;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.recipe_book.ChangeArcaneRecipeBookSettingsPacket;
import com.verdantartifice.primalmagick.common.network.packets.recipe_book.PlaceArcaneRecipePacket;
import com.verdantartifice.primalmagick.common.network.packets.recipe_book.SeenArcaneRecipePacket;
import com.verdantartifice.primalmagick.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArcaneRecipeBookComponent
implements Renderable,
GuiEventListener,
NarratableEntry,
RecipeShownListener,
PlaceRecipe<Ingredient> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected static final ResourceLocation RECIPE_BOOK_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/recipe_book.png");
    protected static final Component SEARCH_HINT = Component.translatable((String)"gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 166;
    private static final int OFFSET_X_POSITION = 86;
    private static final Component ONLY_CRAFTABLES_TOOLTIP = Component.translatable((String)"gui.recipebook.toggleRecipes.craftable");
    private static final Component ALL_RECIPES_TOOLTIP = Component.translatable((String)"gui.recipebook.toggleRecipes.all");
    private static final WidgetSprites FILTER_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled_highlighted"));
    private static final WidgetSprites FURNACE_FILTER_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/furnace_filter_disabled_highlighted"));
    protected int xOffset;
    protected int width;
    protected int height;
    protected final GhostRecipe ghostRecipe = new GhostRecipe();
    protected final List<ArcaneRecipeBookTabButton> tabButtons = Collections.synchronizedList(new ArrayList());
    @Nullable
    protected ArcaneRecipeBookTabButton selectedTab;
    protected StateSwitchingButton filterButton;
    protected final Object filterButtonLock = new Object();
    protected IArcaneRecipeBookMenu<?, ?> menu;
    protected Minecraft mc;
    @Nullable
    protected EditBox searchBox;
    protected String lastSearch = "";
    protected ClientRecipeBook vanillaBook;
    protected ClientArcaneRecipeBook arcaneBook;
    protected final ArcaneRecipeBookPage recipeBookPage = new ArcaneRecipeBookPage();
    protected final StackedComponentContents stackedContents = new StackedComponentContents();
    protected int timesInventoryChanged;
    protected boolean ignoreTextInput;
    protected boolean visible;
    protected boolean widthTooNarrow;
    protected boolean useFurnaceStyle;
    protected boolean isLoading = true;

    public void init(int width, int height, Minecraft mc, boolean tooNarrow, boolean useFurnaceStyle, IArcaneRecipeBookMenu<?, ?> menu) {
        AbstractContainerMenu containerMenu;
        this.mc = mc;
        this.width = width;
        this.height = height;
        this.menu = menu;
        this.widthTooNarrow = tooNarrow;
        this.useFurnaceStyle = useFurnaceStyle;
        mc.player.containerMenu = menu instanceof AbstractContainerMenu ? (containerMenu = (AbstractContainerMenu)menu) : null;
        this.vanillaBook = mc.player.getRecipeBook();
        this.arcaneBook = new ClientArcaneRecipeBook(Services.CAPABILITIES.arcaneRecipeBook((Player)mc.player).orElseThrow(() -> new IllegalArgumentException("No arcane recipe book for player")).get());
        this.visible = this.isVisibleAccordingToBookData();
        if (this.visible) {
            this.initVisuals();
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.mc.level.getRecipeManager().getRecipes(), Util.backgroundExecutor()).thenAccept(recipes -> this.arcaneBook.setupCollections((Iterable<RecipeHolder<?>>)recipes, this.mc.level.registryAccess()))).thenAccept($ -> this.arcaneBook.getCollections().forEach(collection -> collection.updateKnownRecipes((RecipeBook)this.vanillaBook, this.arcaneBook.getData())))).thenAccept($ -> {
            this.isLoading = false;
        })).thenAccept($ -> {
            if (this.visible) {
                this.initVisuals();
            }
        })).exceptionally(e -> {
            LOGGER.error("Failed to load arcane recipe book contents", e);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int xPos = (this.width - 147) / 2 - this.xOffset;
        int yPos = (this.height - 166) / 2;
        this.stackedContents.clear();
        this.mc.player.getInventory().fillStackedContents((StackedContents)this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        String s = this.searchBox != null ? this.searchBox.getValue() : "";
        this.searchBox = new EditBox(this.mc.font, xPos + 25, yPos + 13, 81, 14, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(true);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(0xFFFFFF);
        this.searchBox.setValue(s);
        this.searchBox.setHint(SEARCH_HINT);
        this.searchBox.setEditable(true);
        this.recipeBookPage.init(this.mc, xPos, yPos, this.arcaneBook.getData());
        this.recipeBookPage.addListener(this);
        Object object = this.filterButtonLock;
        synchronized (object) {
            this.filterButton = new StateSwitchingButton(xPos + 110, yPos + 12, 26, 16, this.arcaneBook.getData().isFiltering(this.menu.getRecipeBookType()));
            this.initFilterButtonTextures();
        }
        int tabPosX = (this.width - 147) / 2 - this.xOffset - 30;
        int tabPosY = (this.height - 166) / 2 + 3;
        int tabCount = 0;
        this.tabButtons.clear();
        for (ArcaneRecipeBookCategories category : this.menu.getRecipeBookCategories()) {
            ArcaneRecipeBookTabButton tab2 = new ArcaneRecipeBookTabButton(category);
            tab2.setPosition(tabPosX, tabPosY + 27 * tabCount++);
            tab2.visible = category == ArcaneRecipeBookCategories.CRAFTING_SEARCH;
            this.tabButtons.add(tab2);
        }
        if (this.selectedTab != null) {
            List<ArcaneRecipeBookTabButton> list = this.tabButtons;
            synchronized (list) {
                this.selectedTab = this.tabButtons.stream().filter(tab -> tab.getCategory().equals((Object)this.selectedTab.getCategory())).findFirst().orElse(null);
            }
        }
        if (this.selectedTab == null) {
            this.selectedTab = this.tabButtons.get(0);
        }
        this.selectedTab.setStateTriggered(true);
        if (!this.isLoading) {
            this.updateCollections(false);
        }
        this.updateTabs();
    }

    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(this.useFurnaceStyle ? FURNACE_FILTER_SPRITES : FILTER_SPRITES);
    }

    public int updateScreenPosition(int width, int imageWidth) {
        int retVal = this.isVisible() && !this.widthTooNarrow ? 177 + (width - imageWidth - 200) / 2 : (width - imageWidth) / 2;
        return retVal;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected boolean isVisibleAccordingToBookData() {
        return this.arcaneBook.getData().isOpen(this.menu.getRecipeBookType());
    }

    protected void setVisible(boolean visible) {
        if (visible) {
            this.initVisuals();
        }
        this.visible = visible;
        this.arcaneBook.getData().setOpen(this.menu.getRecipeBookType(), visible);
        if (!visible) {
            this.recipeBookPage.setInvisible();
        }
        this.sendUpdateSettings();
    }

    public void slotClicked(@Nullable Slot slot) {
        if (slot != null && slot.index < this.menu.getSize()) {
            this.ghostRecipe.clear();
            if (this.isVisible()) {
                this.updateStackedContents();
            }
        }
    }

    protected void updateCollections(boolean resetPage) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.arcaneBook.getCollection(this.selectedTab.getCategory()));
        builder.addAll((Iterable)this.vanillaBook.getCollection(this.selectedTab.getCategory().getVanillaCategory()).stream().map(ArcaneRecipeCollection::new).collect(Collectors.toList()));
        ImmutableList recipeCollections = builder.build();
        recipeCollections.forEach(arc -> arc.canCraft(this.stackedContents, this.menu.getGridWidth(), this.menu.getGridHeight(), (RecipeBook)this.vanillaBook, this.arcaneBook.getData()));
        ArrayList<ArcaneRecipeCollection> filteredCollections = new ArrayList<ArcaneRecipeCollection>((Collection<ArcaneRecipeCollection>)recipeCollections);
        filteredCollections.removeIf(arc -> !arc.hasKnownRecipes());
        filteredCollections.removeIf(arc -> !arc.hasFitting());
        String searchStr = this.searchBox.getValue();
        if (!searchStr.isEmpty()) {
            ObjectLinkedOpenHashSet vanillaObjectSet = new ObjectLinkedOpenHashSet((Collection)this.mc.getConnection().searchTrees().recipes().search(searchStr.toLowerCase(Locale.ROOT)).stream().map(ArcaneRecipeCollection::new).collect(Collectors.toList()));
            ObjectLinkedOpenHashSet arcaneObjectSet = new ObjectLinkedOpenHashSet((Collection)ArcaneSearchRegistry.getSearchTree().search(searchStr.toLowerCase(Locale.ROOT)));
            filteredCollections.removeIf(arg_0 -> ArcaneRecipeBookComponent.lambda$updateCollections$12((ObjectSet)vanillaObjectSet, (ObjectSet)arcaneObjectSet, arg_0));
        }
        if (this.arcaneBook.getData().isFiltering(this.menu.getRecipeBookType())) {
            filteredCollections.removeIf(arc -> !arc.hasCraftable());
        }
        this.recipeBookPage.updateCollections(filteredCollections, resetPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTabs() {
        int xPos = (this.width - 147) / 2 - this.xOffset - 30;
        int yPos = (this.height - 166) / 2 + 3;
        int tabCount = 0;
        List<ArcaneRecipeBookTabButton> list = this.tabButtons;
        synchronized (list) {
            for (ArcaneRecipeBookTabButton tab : this.tabButtons) {
                ArcaneRecipeBookCategories category = tab.getCategory();
                if (category != ArcaneRecipeBookCategories.CRAFTING_SEARCH) {
                    if (!tab.updateVisibility(this.vanillaBook, this.arcaneBook)) continue;
                    tab.setPosition(xPos, yPos + 27 * tabCount++);
                    tab.startAnimation(this.mc, this.vanillaBook, this.arcaneBook);
                    continue;
                }
                tab.visible = true;
                tab.setPosition(xPos, yPos + 27 * tabCount++);
            }
        }
    }

    public void tick() {
        boolean flag = this.isVisibleAccordingToBookData();
        if (this.isVisible() != flag) {
            this.setVisible(flag);
        }
        if (this.isVisible() && this.timesInventoryChanged != this.mc.player.getInventory().getTimesChanged()) {
            this.updateStackedContents();
            this.timesInventoryChanged = this.mc.player.getInventory().getTimesChanged();
        }
    }

    protected void updateStackedContents() {
        this.stackedContents.clear();
        this.mc.player.getInventory().fillStackedContents((StackedContents)this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        if (!this.isLoading) {
            this.updateCollections(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0, 0.0, 100.0);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int xPos = (this.width - 147) / 2 - this.xOffset;
            int yPos = (this.height - 166) / 2;
            guiGraphics.blit(RECIPE_BOOK_LOCATION, xPos, yPos, 1, 1, 147, 166);
            this.searchBox.render(guiGraphics, mouseX, mouseY, partialTicks);
            Object object = this.tabButtons;
            synchronized (object) {
                for (ArcaneRecipeBookTabButton tab : this.tabButtons) {
                    tab.render(guiGraphics, mouseX, mouseY, partialTicks);
                }
            }
            object = this.filterButtonLock;
            synchronized (object) {
                this.filterButton.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
            this.recipeBookPage.render(guiGraphics, xPos, yPos, mouseX, mouseY, partialTicks);
            guiGraphics.pose().popPose();
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, int parentLeft, int parentTop, int mouseX, int mouseY) {
        if (this.isVisible()) {
            this.recipeBookPage.renderTooltip(guiGraphics, mouseX, mouseY);
            if (this.filterButton.isHoveredOrFocused() && this.mc.screen != null) {
                guiGraphics.renderTooltip(this.mc.font, this.getFilterButtonTooltip(), mouseX, mouseY);
            }
            this.renderGhostRecipeTooltip(guiGraphics, parentLeft, parentTop, mouseX, mouseY);
        }
    }

    protected Component getFilterButtonTooltip() {
        return this.filterButton.isStateTriggered() ? this.getRecipeFilterName() : ALL_RECIPES_TOOLTIP;
    }

    protected Component getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    protected void renderGhostRecipeTooltip(GuiGraphics guiGraphics, int parentLeft, int parentTop, int mouseX, int mouseY) {
        ItemStack stack = null;
        for (int index = 0; index < this.ghostRecipe.size(); ++index) {
            GhostRecipe.GhostIngredient ghostIngredient = this.ghostRecipe.get(index);
            int xPos = ghostIngredient.getX() + parentLeft;
            int yPos = ghostIngredient.getY() + parentTop;
            if (mouseX < xPos || mouseY < yPos || mouseX >= xPos + 16 || mouseY >= yPos + 16) continue;
            stack = ghostIngredient.getItem();
        }
        if (stack != null && this.mc.screen != null) {
            guiGraphics.renderComponentTooltip(this.mc.font, Screen.getTooltipFromItem((Minecraft)this.mc, stack), mouseX, mouseY);
        }
    }

    public void renderGhostRecipe(GuiGraphics guiGraphics, int parentLeft, int parentTop, boolean largeSlot, float partialTicks) {
        this.ghostRecipe.render(guiGraphics, this.mc, parentLeft, parentTop, largeSlot, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(double mouseX, double mouseY, int buttonIndex) {
        if (this.isVisible() && !this.mc.player.isSpectator()) {
            if (this.recipeBookPage.mouseClicked(mouseX, mouseY, buttonIndex, (this.width - 147) / 2 - this.xOffset, (this.height - 166) / 2, 147, 166)) {
                RecipeHolder<?> recipe = this.recipeBookPage.getLastClickedRecipe();
                ArcaneRecipeCollection collection = this.recipeBookPage.getLastClickedRecipeCollection();
                if (recipe != null && collection != null) {
                    if (!collection.isCraftable(recipe) && this.ghostRecipe.getRecipe() == recipe) {
                        return false;
                    }
                    this.ghostRecipe.clear();
                    PacketHandler.sendToServer(new PlaceArcaneRecipePacket(this.mc.player.containerMenu.containerId, recipe, Screen.hasShiftDown()));
                    if (!this.isOffsetNextToMainGUI()) {
                        this.setVisible(false);
                    }
                }
                return true;
            }
            if (this.searchBox.mouseClicked(mouseX, mouseY, buttonIndex)) {
                this.searchBox.setFocused(true);
                return true;
            }
            this.searchBox.setFocused(false);
            if (this.filterButton.mouseClicked(mouseX, mouseY, buttonIndex)) {
                this.filterButton.setStateTriggered(this.toggleFiltering());
                this.sendUpdateSettings();
                if (!this.isLoading) {
                    this.updateCollections(false);
                }
                return true;
            }
            List<ArcaneRecipeBookTabButton> list = this.tabButtons;
            synchronized (list) {
                for (ArcaneRecipeBookTabButton tab : this.tabButtons) {
                    if (!tab.mouseClicked(mouseX, mouseY, buttonIndex)) continue;
                    if (this.selectedTab != tab) {
                        if (this.selectedTab != null) {
                            this.selectedTab.setStateTriggered(false);
                        }
                        this.selectedTab = tab;
                        this.selectedTab.setStateTriggered(true);
                        if (!this.isLoading) {
                            this.updateCollections(true);
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean toggleFiltering() {
        ArcaneRecipeBookType type = this.menu.getRecipeBookType();
        boolean newValue = !this.arcaneBook.getData().isFiltering(type);
        this.arcaneBook.getData().setFiltering(type, newValue);
        return newValue;
    }

    public boolean hasClickedOutside(double mouseX, double mouseY, int parentLeft, int parentTop, int parentWidth, int parentHeight, int buttonIndex) {
        if (!this.isVisible()) {
            return true;
        }
        boolean flag = mouseX < (double)parentLeft || mouseY < (double)parentTop || mouseX >= (double)(parentLeft + parentWidth) || mouseY >= (double)(parentTop + parentHeight);
        boolean flag1 = (double)(parentLeft - 147) < mouseX && mouseX < (double)parentLeft && (double)parentTop < mouseY && mouseY < (double)(parentTop + parentHeight);
        return flag && !flag1 && !this.selectedTab.isHoveredOrFocused();
    }

    public boolean keyPressed(int p_94745_, int p_94746_, int p_94747_) {
        this.ignoreTextInput = false;
        if (this.isVisible() && !this.mc.player.isSpectator()) {
            if (p_94745_ == 256 && !this.isOffsetNextToMainGUI()) {
                this.setVisible(false);
                return true;
            }
            if (this.searchBox.keyPressed(p_94745_, p_94746_, p_94747_)) {
                this.checkSearchStringUpdate();
                return true;
            }
            if (this.searchBox.isFocused() && this.searchBox.isVisible() && p_94745_ != 256) {
                return true;
            }
            if (this.mc.options.keyChat.matches(p_94745_, p_94746_) && !this.searchBox.isFocused()) {
                this.ignoreTextInput = true;
                this.searchBox.setFocused(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean keyReleased(int p_94750_, int p_94751_, int p_94752_) {
        this.ignoreTextInput = false;
        return super.keyReleased(p_94750_, p_94751_, p_94752_);
    }

    public boolean charTyped(char p_94732_, int p_94733_) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (this.isVisible() && !this.mc.player.isSpectator()) {
            if (this.searchBox.charTyped(p_94732_, p_94733_)) {
                this.checkSearchStringUpdate();
                return true;
            }
            return super.charTyped(p_94732_, p_94733_);
        }
        return false;
    }

    public boolean isMouseOver(double p_94748_, double p_94749_) {
        return false;
    }

    protected void checkSearchStringUpdate() {
        String str = this.searchBox.getValue().toLowerCase(Locale.ROOT);
        if (!str.equals(this.lastSearch)) {
            if (!this.isLoading) {
                this.updateCollections(false);
            }
            this.lastSearch = str;
        }
    }

    protected boolean isOffsetNextToMainGUI() {
        return this.xOffset == 86;
    }

    public void recipesUpdated() {
        this.updateTabs();
        if (this.isVisible() && !this.isLoading) {
            this.updateCollections(false);
        }
    }

    public void recipesShown(List<RecipeHolder<?>> recipes) {
        for (RecipeHolder<?> recipe : recipes) {
            this.mc.player.removeRecipeHighlight(recipe);
            if (!this.arcaneBook.getData().willHighlight(recipe)) continue;
            this.arcaneBook.getData().removeHighlight(recipe);
            PacketHandler.sendToServer(new SeenArcaneRecipePacket(recipe));
        }
    }

    public void setupGhostRecipe(RecipeHolder<?> recipe, List<Slot> slots) {
        ItemStack stack = recipe.value().getResultItem((HolderLookup.Provider)this.mc.level.registryAccess());
        this.ghostRecipe.setRecipe(recipe);
        this.ghostRecipe.addIngredient(Ingredient.of((ItemStack[])new ItemStack[]{stack}), slots.get((int)0).x, slots.get((int)0).y);
        this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipe, recipe.value().getIngredients().iterator(), 0);
    }

    public void addItemToSlot(Ingredient ingredient, int slotIndex, int count, int p_135418_, int p_135419_) {
        if (!ingredient.isEmpty()) {
            Slot slot = (Slot)this.menu.getSlots().get(slotIndex);
            this.ghostRecipe.addIngredient(ingredient, slot.x, slot.y);
        }
    }

    protected void sendUpdateSettings() {
        ArcaneRecipeBookType type = this.menu.getRecipeBookType();
        boolean open = this.arcaneBook.getData().getBookSettings().isOpen(type);
        boolean filtering = this.arcaneBook.getData().getBookSettings().isFiltering(type);
        PacketHandler.sendToServer(new ChangeArcaneRecipeBookSettingsPacket(type, open, filtering));
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.visible ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput output) {
        ArrayList<Object> entryList = new ArrayList<Object>();
        this.recipeBookPage.listButtons(widget -> {
            if (widget.isActive()) {
                entryList.add(widget);
            }
        });
        entryList.add(this.searchBox);
        entryList.add(this.filterButton);
        entryList.addAll(this.tabButtons);
        Screen.NarratableSearchResult result = Screen.findNarratableWidget(entryList, null);
        if (result != null) {
            result.entry.updateNarration(output.nest());
        }
    }

    public void setFocused(boolean p_265728_) {
    }

    public boolean isFocused() {
        return false;
    }

    private static /* synthetic */ boolean lambda$updateCollections$12(ObjectSet vanillaObjectSet, ObjectSet arcaneObjectSet, ArcaneRecipeCollection arc) {
        return !vanillaObjectSet.contains((Object)arc) && !arcaneObjectSet.contains((Object)arc);
    }
}

