/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.radial;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.radial.DrawingContext;
import com.verdantartifice.primalmagick.client.gui.radial.GenericRadialMenu;
import com.verdantartifice.primalmagick.client.gui.radial.TextRadialMenuItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class ItemStackRadialMenuItem
extends TextRadialMenuItem {
    private final int slot;
    private final ItemStack stack;

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemStackRadialMenuItem(GenericRadialMenu owner, int slot, ItemStack stack, Component altText) {
        super(owner, altText, Integer.MAX_VALUE);
        this.slot = slot;
        this.stack = stack;
    }

    @Override
    public void draw(DrawingContext context) {
        if (this.stack.getCount() > 0) {
            Matrix4fStack viewModelPose = RenderSystem.getModelViewStack();
            viewModelPose.pushMatrix();
            viewModelPose.mul((Matrix4fc)context.guiGraphics.pose().last().pose());
            viewModelPose.translate(-8.0f, -8.0f, context.z);
            RenderSystem.applyModelViewMatrix();
            context.guiGraphics.renderItem(this.stack, (int)context.x, (int)context.y);
            context.guiGraphics.renderItemDecorations(context.fontRenderer, this.stack, (int)context.x, (int)context.y, "");
            viewModelPose.popMatrix();
            RenderSystem.applyModelViewMatrix();
        } else {
            super.draw(context);
        }
    }

    @Override
    public void drawTooltips(DrawingContext context) {
        if (this.stack.getCount() > 0) {
            context.drawingHelper.renderTooltip(context.guiGraphics, this.stack, (int)context.x, (int)context.y);
        } else {
            super.drawTooltips(context);
        }
    }
}

