/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.radial;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.radial.DrawingContext;
import com.verdantartifice.primalmagick.client.gui.radial.GenericRadialMenu;
import com.verdantartifice.primalmagick.client.gui.radial.TextRadialMenuItem;
import java.util.Collections;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ImageRadialMenuItem
extends TextRadialMenuItem {
    private final ResourceLocation imageLoc;
    private final int slot;

    public ImageRadialMenuItem(GenericRadialMenu owner, int slot, ResourceLocation imageLoc, Component altText) {
        super(owner, altText, Integer.MAX_VALUE);
        this.imageLoc = imageLoc;
        this.slot = slot;
    }

    public int getSlot() {
        return this.slot;
    }

    public ResourceLocation getImageLoc() {
        return this.imageLoc;
    }

    @Override
    public void draw(DrawingContext context) {
        if (this.imageLoc == null) {
            super.draw(context);
        } else {
            context.guiGraphics.pose().pushPose();
            context.guiGraphics.pose().translate(-8.0f, -8.0f, context.z + 200.0f);
            context.guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            context.guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            context.guiGraphics.blit(this.imageLoc, 2 * (int)context.x, 2 * (int)context.y, 0.0f, 0.0f, 32, 32, 32, 32);
            context.guiGraphics.pose().popPose();
        }
    }

    @Override
    public void drawTooltips(DrawingContext context) {
        if (this.getText() == null) {
            super.drawTooltips(context);
        } else {
            context.drawingHelper.renderTooltip(context.guiGraphics, Collections.singletonList(this.getText()), (int)context.x, (int)context.y);
        }
    }
}

