/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerWard;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class WardingHudOverlay {
    public static final ResourceLocation ID = ResourceUtils.loc("warding_hud_overlay");
    protected static final ResourceLocation GUI_ICONS_LOCATION = ResourceUtils.loc("textures/gui/hud.png");

    public static boolean shouldRender() {
        Minecraft mc = Minecraft.getInstance();
        return !mc.options.hideGui && mc.gameMode.canHurtPlayer() && mc.getCameraEntity() instanceof Player;
    }

    public static void render(GuiGraphics pGuiGraphics, DeltaTracker pDeltaTracker) {
        int ward;
        if (!WardingHudOverlay.shouldRender()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        mc.getProfiler().push("warding");
        RenderSystem.enableBlend();
        Player player = (Player)mc.getCameraEntity();
        Optional<IPlayerWard> wardCapOpt = Services.CAPABILITIES.ward(player);
        int wardLast = ward = Mth.ceil((float)wardCapOpt.map(IPlayerWard::getCurrentWard).orElse(Float.valueOf(0.0f)).floatValue());
        boolean highlight = false;
        float wardMax = wardCapOpt.map(IPlayerWard::getMaxWard).orElse(Float.valueOf(0.0f)).floatValue();
        int absorb = 0;
        int wardRows = Mth.ceil((float)(wardMax / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (wardRows - 2), 3);
        if (wardMax > 0.0f) {
            int left = pGuiGraphics.guiWidth() / 2 - 91;
            int top = pGuiGraphics.guiHeight() - 28 - rowHeight;
            int regen = -1;
            if (wardCapOpt.map(IPlayerWard::isRegenerating).orElse(false).booleanValue()) {
                regen = mc.gui.getGuiTicks() % Mth.ceil((float)(wardMax + 5.0f));
            }
            WardingHudOverlay.renderPentacles(pGuiGraphics, player, left, top, rowHeight, regen, wardMax, ward, wardLast, absorb, highlight);
        }
        RenderSystem.disableBlend();
        mc.getProfiler().pop();
    }

    private static void renderPentacles(GuiGraphics guiGraphics, Player player, int left, int top, int rowHeight, int regen, float wardMax, int ward, int wardLast, int absorb, boolean highlight) {
        int maxHealthHearts = Mth.ceil((double)((double)wardMax / 2.0));
        int maxAbsorbHearts = Mth.ceil((double)((double)absorb / 2.0));
        for (int index = maxHealthHearts + maxAbsorbHearts - 1; index >= 0; --index) {
            int row = index / 10;
            int col = index % 10;
            int xPos = left + col * 8;
            int yPos = top - row * rowHeight;
            if (index < maxHealthHearts && index == regen) {
                yPos -= 2;
            }
            WardingHudOverlay.renderPentacle(guiGraphics, xPos, yPos, 87, 0, highlight, false);
            int doubleIndex = index * 2;
            if (highlight && doubleIndex < wardLast) {
                WardingHudOverlay.renderPentacle(guiGraphics, xPos, yPos, 96, 0, true, doubleIndex + 1 == wardLast);
            }
            if (doubleIndex >= ward) continue;
            WardingHudOverlay.renderPentacle(guiGraphics, xPos, yPos, 96, 0, false, doubleIndex + 1 == ward);
        }
    }

    private static void renderPentacle(GuiGraphics guiGraphics, int xPos, int yPos, int textureX, int textureY, boolean highlight, boolean isHalf) {
        guiGraphics.blit(GUI_ICONS_LOCATION, xPos, yPos, textureX + (isHalf ? 9 : 0), textureY, 9, 9);
    }
}

