/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.wands.IWand;
import com.verdantartifice.primalmagick.common.wands.ManaManager;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class WandHudOverlay {
    public static final ResourceLocation ID = ResourceUtils.loc("wand_hud_overlay");
    private static final ResourceLocation HUD_TEXTURE = ResourceUtils.loc("textures/gui/hud.png");

    public static boolean shouldRender() {
        Minecraft mc = Minecraft.getInstance();
        return !mc.options.hideGui && mc.player != null && !mc.player.isSpectator() && Services.CONFIG.showWandHud() && (mc.player.getMainHandItem().getItem() instanceof IWand || mc.player.getOffhandItem().getItem() instanceof IWand);
    }

    public static void render(GuiGraphics pGuiGraphics, DeltaTracker pDeltaTracker) {
        if (WandHudOverlay.shouldRender()) {
            Minecraft mc = Minecraft.getInstance();
            WandHudOverlay.renderHud(mc, pGuiGraphics, mc.player.getMainHandItem(), mc.player.getOffhandItem(), pDeltaTracker.getGameTimeDeltaPartialTick(true));
        }
    }

    private static void renderHud(Minecraft mc, GuiGraphics guiGraphics, ItemStack mainHandStack, ItemStack offHandStack, float partialTick) {
        guiGraphics.pose().pushPose();
        int posY = 0;
        SpellPackage activeSpell = SpellManager.getActiveSpell(mainHandStack, offHandStack);
        ResourceLocation spellIcon = activeSpell == null ? null : activeSpell.getIcon();
        posY += WandHudOverlay.renderSpellDisplay(guiGraphics, 0, posY, spellIcon, partialTick);
        int index = 0;
        List<Source> discoveredSources = Sources.getAllSorted().stream().filter(s -> s.isDiscovered((Player)mc.player)).toList();
        for (Source source : discoveredSources) {
            int maxMana = ManaManager.getMaxMana((Player)mc.player, source);
            MutableComponent maxText = ManaManager.getMaxManaText((Player)mc.player, source);
            int curMana = ManaManager.getMana((Player)mc.player, source);
            MutableComponent curText = ManaManager.getManaText((Player)mc.player, source);
            double ratio = (double)curMana / (double)maxMana;
            MutableComponent ratioText = Component.translatable((String)"tooltip.primalmagick.source.mana_summary_fragment", (Object[])new Object[]{curText, maxText});
            posY += WandHudOverlay.renderManaGauge(guiGraphics, 0, posY, (Component)ratioText, ratio, source.getColor(), ++index == discoveredSources.size(), partialTick, mc.font);
        }
        guiGraphics.pose().popPose();
    }

    private static int renderSpellDisplay(GuiGraphics guiGraphics, int x, int y, ResourceLocation spellIcon, float partialTick) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(HUD_TEXTURE, x, y, 60.0f, 0.0f, 26, 26, 256, 256);
        if (spellIcon != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            guiGraphics.blit(spellIcon, x + 10, y + 10, 0.0f, 0.0f, 32, 32, 32, 32);
            guiGraphics.pose().popPose();
        }
        return 26;
    }

    private static int renderManaGauge(GuiGraphics guiGraphics, int x, int y, Component text, double ratio, int color, boolean isLast, float partialTick, Font font) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(HUD_TEXTURE, x, y, 0.0f, 0.0f, 59, 12, 256, 256);
        if (!isLast) {
            guiGraphics.blit(HUD_TEXTURE, x + 4, y + 8, 4.0f, 12.0f, 2, 4, 256, 256);
        }
        guiGraphics.setColor(WandHudOverlay.getRed(color), WandHudOverlay.getGreen(color), WandHudOverlay.getBlue(color), 1.0f);
        guiGraphics.blit(HUD_TEXTURE, x + 14, y + 2, 14.0f, 12.0f, (int)(40.0 * ratio), 8, 256, 256);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (Screen.hasShiftDown()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(61.0f, 2.0f, 0.0f);
            guiGraphics.drawString(font, text, x, y, -1);
            guiGraphics.pose().popPose();
        }
        return 12;
    }

    private static float getRed(int color) {
        return (float)FastColor.ARGB32.red((int)color) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)FastColor.ARGB32.green((int)color) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)FastColor.ARGB32.blue((int)color) / 255.0f;
    }
}

