/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.hud;

import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractManaStorageItemDecorator {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Source source;

    public AbstractManaStorageItemDecorator(Source source) {
        this.source = source;
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        ManaStorage manaCap = (ManaStorage)stack.get(DataComponentsPM.CAPABILITY_MANA_STORAGE.get());
        if (manaCap != null && manaCap.canStore(this.source)) {
            int width = this.getBarWidth(stack, this.source);
            int color = this.getBarColor(stack, this.source);
            int xPos = xOffset + 2;
            int yPos = yOffset + 13;
            if (stack.isBarVisible()) {
                guiGraphics.fill(RenderType.guiOverlay(), xPos, yPos - 1, xPos + 13, yPos, -16777216);
                guiGraphics.fill(RenderType.guiOverlay(), xPos, yPos - 1, xPos + width, yPos, color | 0xFF000000);
            } else {
                guiGraphics.fill(RenderType.guiOverlay(), xPos, yPos, xPos + 13, yPos + 2, -16777216);
                guiGraphics.fill(RenderType.guiOverlay(), xPos, yPos, xPos + width, yPos + 1, color | 0xFF000000);
            }
        }
        return false;
    }

    protected int getBarWidth(ItemStack stack, Source source) {
        ManaStorage manaCap = (ManaStorage)stack.get(DataComponentsPM.CAPABILITY_MANA_STORAGE.get());
        if (manaCap != null && manaCap.canStore(this.source)) {
            return Math.round((float)manaCap.getManaStored(source) * 13.0f / (float)manaCap.getMaxManaStored(source));
        }
        return 0;
    }

    protected int getBarColor(ItemStack stack, Source source) {
        return 2613703;
    }
}

