/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IngredientWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemStackWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RecipeExpertiseWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RecipeTypeWidget;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RunecarvingRecipePage
extends AbstractRecipePage {
    protected RecipeHolder<IRunecarvingRecipe> recipe;

    public RunecarvingRecipePage(RecipeHolder<IRunecarvingRecipe> recipe, RegistryAccess registryAccess) {
        super(registryAccess);
        this.recipe = recipe;
    }

    @Override
    protected Component getTitleText() {
        ItemStack stack = ((IRunecarvingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.registryAccess);
        return stack.getItem().getName(stack);
    }

    @Override
    protected String getRecipeTypeTranslationKey() {
        return "grimoire.primalmagick.runecarving_recipe_header";
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        int indent = 84;
        int overlayWidth = 13;
        screen.addWidgetToScreen(new IngredientWidget((Ingredient)((IRunecarvingRecipe)this.recipe.value()).getIngredients().get(0), x - 6 + side * 140 + indent / 2, y + 99, screen));
        screen.addWidgetToScreen(new IngredientWidget((Ingredient)((IRunecarvingRecipe)this.recipe.value()).getIngredients().get(1), x + 58 + side * 140 + indent / 2 - overlayWidth / 2, y + 99, screen));
        screen.addWidgetToScreen(new ItemStackWidget(((IRunecarvingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.registryAccess), x + 29 + side * 140 + indent / 2 - overlayWidth / 2, y + 30, false));
        screen.addWidgetToScreen(new RecipeTypeWidget(this.recipe.value(), x - 22 + side * 140 + indent / 2 - overlayWidth / 2, y + 30, (Component)Component.translatable((String)this.getRecipeTypeTranslationKey())));
        if (((IRunecarvingRecipe)this.recipe.value()).hasExpertiseReward(this.registryAccess)) {
            screen.addWidgetToScreen(new RecipeExpertiseWidget(this.recipe, x - 6 + side * 140 + indent / 2 - overlayWidth / 2, y + 30));
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        super.render(guiGraphics, side, x, y, mouseX, mouseY);
        y += 53;
        int indent = 84;
        int overlayWidth = 13;
        int overlayHeight = 13;
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().translate((float)(x + 16 + side * 140 + indent / 2 - overlayWidth / 2), (float)(y + 68), 0.0f);
        guiGraphics.pose().scale(2.0f, 2.0f, 1.0f);
        guiGraphics.blit(OVERLAY, 0, 0, 0, 51, overlayWidth, overlayHeight);
        guiGraphics.pose().popPose();
    }
}

