/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RuneEnchantmentButton;
import com.verdantartifice.primalmagick.common.research.topics.OtherResearchTopic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;

public class RuneEnchantmentIndexPage
extends AbstractPage {
    public static final OtherResearchTopic TOPIC = new OtherResearchTopic("rune_enchantments", 0);
    protected List<Holder<Enchantment>> contents = new ArrayList<Holder<Enchantment>>();
    protected boolean firstPage;

    public RuneEnchantmentIndexPage() {
        this(false);
    }

    public RuneEnchantmentIndexPage(boolean first) {
        this.firstPage = first;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        if (this.isFirstPage() && side == 0) {
            this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, null);
        }
    }

    @Nonnull
    public List<Holder<Enchantment>> getEnchantments() {
        return Collections.unmodifiableList(this.contents);
    }

    public boolean addEnchantment(Holder<Enchantment> enchant) {
        return this.contents.add(enchant);
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    @Override
    protected Component getTitleText() {
        return Component.translatable((String)"grimoire.primalmagick.rune_enchantment_header");
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        for (Holder<Enchantment> enchant : this.getEnchantments()) {
            Component text = ((Enchantment)enchant.value()).description();
            screen.addWidgetToScreen(new RuneEnchantmentButton(x + 12 + side * 140, y, text, screen, enchant));
            y += 12;
        }
    }
}

