/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.BlockIngredientWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IngredientWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemStackWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ManaCostSummaryWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RecipeExpertiseWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RecipeTypeWidget;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RitualRecipePage
extends AbstractRecipePage {
    protected static final int ITEMS_PER_ROW = 7;
    protected RecipeHolder<IRitualRecipe> recipe;

    public RitualRecipePage(RecipeHolder<IRitualRecipe> recipe, RegistryAccess registryAccess) {
        super(registryAccess);
        this.recipe = recipe;
    }

    @Override
    protected Component getTitleText() {
        ItemStack stack = ((IRitualRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.registryAccess);
        return stack.getItem().getName(stack);
    }

    @Override
    protected String getRecipeTypeTranslationKey() {
        return "grimoire.primalmagick.ritual_recipe_header";
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        int indent = 124;
        int overlayWidth = 52;
        int deltaX = 0;
        Minecraft mc = Minecraft.getInstance();
        ItemStack output = ((IRitualRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.registryAccess);
        screen.addWidgetToScreen(new ItemStackWidget(output, x + 27 + side * 140 + indent / 2 - overlayWidth / 2, y += 25, false));
        if (!((IRitualRecipe)this.recipe.value()).getManaCosts().isEmpty()) {
            screen.addWidgetToScreen(new ManaCostSummaryWidget(((IRitualRecipe)this.recipe.value()).getManaCosts(), x + 75 + side * 140 + indent / 2 - overlayWidth / 2, y));
        }
        screen.addWidgetToScreen(new RecipeTypeWidget(this.recipe.value(), x - 22 + side * 140 + indent / 2 - overlayWidth / 2, y, (Component)Component.translatable((String)this.getRecipeTypeTranslationKey())));
        if (((IRitualRecipe)this.recipe.value()).hasExpertiseReward(this.registryAccess)) {
            screen.addWidgetToScreen(new RecipeExpertiseWidget(this.recipe, x - 6 + side * 140 + indent / 2 - overlayWidth / 2, y));
        }
        y += 28;
        if (!((IRitualRecipe)this.recipe.value()).getIngredients().isEmpty()) {
            Objects.requireNonNull(mc.font);
            y += 9;
            for (Ingredient ingredient : ((IRitualRecipe)this.recipe.value()).getIngredients()) {
                if (deltaX >= 126) {
                    deltaX = 0;
                    y += 18;
                }
                screen.addWidgetToScreen(new IngredientWidget(ingredient, x + 8 + deltaX + side * 144, y, screen));
                deltaX += 18;
            }
            deltaX = 0;
            y += 18;
            Objects.requireNonNull(mc.font);
            y += (int)(9.0f * 0.66f);
        }
        if (!((IRitualRecipe)this.recipe.value()).getProps().isEmpty()) {
            Objects.requireNonNull(mc.font);
            y += 9;
            for (BlockIngredient prop : ((IRitualRecipe)this.recipe.value()).getProps()) {
                if (deltaX >= 126) {
                    deltaX = 0;
                    y += 18;
                }
                screen.addWidgetToScreen(new BlockIngredientWidget(prop, x + 8 + deltaX + side * 144, y));
                deltaX += 18;
            }
            deltaX = 0;
            y += 18;
            Objects.requireNonNull(mc.font);
            y += (int)(9.0f * 0.66f);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        MutableComponent leadComponent;
        super.render(guiGraphics, side, x, y, mouseX, mouseY);
        y += 79;
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.getInstance();
        if (!((IRitualRecipe)this.recipe.value()).getIngredients().isEmpty()) {
            leadComponent = Component.translatable((String)"grimoire.primalmagick.ritual_offerings_header").withStyle(ChatFormatting.UNDERLINE);
            guiGraphics.drawString(mc.font, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.font);
            y += 9;
            y += 18 * Mth.ceil((double)((double)((IRitualRecipe)this.recipe.value()).getIngredients().size() / 7.0));
            Objects.requireNonNull(mc.font);
            y += (int)(9.0f * 0.66f);
        }
        if (!((IRitualRecipe)this.recipe.value()).getProps().isEmpty()) {
            leadComponent = Component.translatable((String)"grimoire.primalmagick.ritual_props_header").withStyle(ChatFormatting.UNDERLINE);
            guiGraphics.drawString(mc.font, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.font);
            y += 9;
            y += 18 * Mth.ceil((double)((double)((IRitualRecipe)this.recipe.value()).getProps().size() / 7.0));
            Objects.requireNonNull(mc.font);
            y += (int)(9.0f * 0.66f);
        }
        MutableComponent headerComponent = Component.translatable((String)"ritual.primalmagick.instability.header").withStyle(ChatFormatting.UNDERLINE);
        int rating = Mth.clamp((int)(((IRitualRecipe)this.recipe.value()).getInstability() / 2), (int)0, (int)5);
        MutableComponent valueComponent = Component.translatable((String)("ritual.primalmagick.instability.rating." + rating));
        MutableComponent lineComponent = Component.translatable((String)"ritual.primalmagick.instability", (Object[])new Object[]{headerComponent, valueComponent});
        guiGraphics.drawString(mc.font, (Component)lineComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.font);
        y += 9;
        guiGraphics.pose().popPose();
    }
}

