/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.widgets.InactiveWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ProgressButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RequirementWidgetFactory;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.research.requirements.RequirementCategory;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class RequirementsPage
extends AbstractPage {
    protected static final int ITEMS_PER_ROW = 7;
    protected ResearchStage stage;

    public RequirementsPage(ResearchStage stage) {
        this.stage = stage;
    }

    @Override
    protected boolean renderTopTitleBar() {
        return false;
    }

    @Override
    protected Component getTitleText() {
        return Component.translatable((String)"grimoire.primalmagick.requirements_header");
    }

    protected int initWidgetCategory(GrimoireScreen screen, RequirementCategory category, int x, int y) {
        int startX = x;
        int widgetHeight = Integer.MIN_VALUE;
        Minecraft mc = Minecraft.getInstance();
        List<AbstractRequirement<?>> reqs = this.stage.getRequirementsByCategory(category);
        if (!reqs.isEmpty()) {
            Objects.requireNonNull(mc.font);
            y += 9;
            List<Boolean> completion = this.stage.getRequirementCompletionByCategory((Player)mc.player, category);
            for (int index = 0; index < reqs.size(); ++index) {
                AbstractWidget widget;
                if (index > 0 && index % 7 == 0 && widgetHeight > 0) {
                    x = startX;
                    y += widgetHeight + 2;
                }
                if ((widget = RequirementWidgetFactory.fromRequirement(reqs.get(index), x, y, completion.get(index))) != null) {
                    screen.addWidgetToScreen(widget);
                    widgetHeight = Math.max(widgetHeight, widget.getHeight());
                }
                x += 18;
            }
            if (widgetHeight > 0) {
                y += widgetHeight + 2;
            }
        }
        return y;
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        int startX = x;
        int startY = y;
        y += 27;
        Minecraft mc = Minecraft.getInstance();
        int widgetX = x + 8 + side * 144;
        y = this.initWidgetCategory(screen, RequirementCategory.MUST_OBTAIN, widgetX, y);
        y = this.initWidgetCategory(screen, RequirementCategory.MUST_CRAFT, widgetX, y);
        y = this.initWidgetCategory(screen, RequirementCategory.KNOWLEDGE, widgetX, y);
        y = this.initWidgetCategory(screen, RequirementCategory.RESEARCH, widgetX, y);
        y = this.initWidgetCategory(screen, RequirementCategory.STAT, widgetX, y);
        y = startY + 141;
        if (screen.isProgressing()) {
            MutableComponent text = Component.translatable((String)"grimoire.primalmagick.completing_text");
            screen.addWidgetToScreen(new InactiveWidget(startX + 16 + side * 136, y, 119, 20, (Component)text));
        } else if (this.stage.arePrerequisitesMet((Player)mc.player)) {
            MutableComponent text = Component.translatable((String)"grimoire.primalmagick.complete_button");
            screen.addWidgetToScreen(new ProgressButton(this.stage, startX + 16 + side * 136, y, (Component)text, screen));
        }
    }

    public int renderRequirementsLabel(GuiGraphics guiGraphics, RequirementCategory category, String textTranslationKey, int x, int y, int widgetHeight) {
        Minecraft mc = Minecraft.getInstance();
        List<AbstractRequirement<?>> reqs = this.stage.getRequirementsByCategory(category);
        if (!reqs.isEmpty()) {
            MutableComponent leadComponent = Component.translatable((String)textTranslationKey).withStyle(ChatFormatting.UNDERLINE);
            guiGraphics.drawString(mc.font, (Component)leadComponent, x, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.font);
            y += 9;
            y += (widgetHeight + 2) * (1 + reqs.size() / 7);
        }
        return y;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, null);
        y += 53;
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
        int labelX = x - 3 + side * 140;
        y = this.renderRequirementsLabel(guiGraphics, RequirementCategory.MUST_OBTAIN, "grimoire.primalmagick.must_obtain_header", labelX, y, 16);
        y = this.renderRequirementsLabel(guiGraphics, RequirementCategory.MUST_CRAFT, "grimoire.primalmagick.must_craft_header", labelX, y, 16);
        y = this.renderRequirementsLabel(guiGraphics, RequirementCategory.KNOWLEDGE, "grimoire.primalmagick.required_knowledge_header", labelX, y, 16);
        y = this.renderRequirementsLabel(guiGraphics, RequirementCategory.RESEARCH, "grimoire.primalmagick.required_research_header", labelX, y, 16);
        y = this.renderRequirementsLabel(guiGraphics, RequirementCategory.STAT, "grimoire.primalmagick.required_stats_header", labelX, y, 18);
        guiGraphics.pose().popPose();
    }
}

