/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ConcoctingRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.DissolutionRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RitualRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RunecarvingRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapedArcaneRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapedRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapelessArcaneRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapelessRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.SmeltingRecipePage;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IShapelessArcaneRecipePM;
import com.verdantartifice.primalmagick.common.crafting.ShapedArcaneRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class RecipePageFactory {
    @Nonnull
    public static AbstractRecipePage createPage(@Nonnull RecipeHolder<?> recipeHolder, RegistryAccess registryAccess) {
        Recipe recipe = recipeHolder.value();
        if (recipe instanceof SmeltingRecipe) {
            return new SmeltingRecipePage(recipeHolder, registryAccess);
        }
        if (recipe instanceof IRitualRecipe) {
            return new RitualRecipePage(recipeHolder, registryAccess);
        }
        if (recipe instanceof IRunecarvingRecipe) {
            return new RunecarvingRecipePage(recipeHolder, registryAccess);
        }
        if (recipe instanceof IConcoctingRecipe) {
            return new ConcoctingRecipePage((RecipeHolder<? extends IConcoctingRecipe>)recipeHolder, registryAccess);
        }
        if (recipe instanceof IDissolutionRecipe) {
            return new DissolutionRecipePage(recipeHolder, registryAccess);
        }
        if (recipe instanceof ShapedArcaneRecipe) {
            return new ShapedArcaneRecipePage((RecipeHolder<? extends ShapedArcaneRecipe>)recipeHolder, registryAccess);
        }
        if (recipe instanceof IShapelessArcaneRecipePM) {
            return new ShapelessArcaneRecipePage((RecipeHolder<? extends IShapelessArcaneRecipePM>)recipeHolder, registryAccess);
        }
        if (recipe instanceof ShapedRecipe) {
            return new ShapedRecipePage((RecipeHolder<? extends ShapedRecipe>)recipeHolder, registryAccess);
        }
        return new ShapelessRecipePage(recipeHolder, registryAccess);
    }
}

