/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.DisciplineButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.EntryButton;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeMetadataPage
extends AbstractPage {
    protected final RecipeHolder<?> recipeHolder;
    protected final RegistryAccess registryAccess;
    protected final boolean firstPage;

    public RecipeMetadataPage(RecipeHolder<?> recipe, RegistryAccess registryAccess) {
        this(recipe, registryAccess, false);
    }

    public RecipeMetadataPage(RecipeHolder<?> recipe, RegistryAccess registryAccess, boolean firstPage) {
        this.recipeHolder = recipe;
        this.registryAccess = registryAccess;
        this.firstPage = firstPage;
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    @Override
    protected boolean renderTopTitleBar() {
        return false;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, null);
        y += 53;
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        boolean isEntryMissing = ResearchManager.getEntryForRecipe(this.registryAccess, this.recipeHolder.id()).isEmpty();
        MutableComponent noneComponent = Component.translatable((String)"tooltip.primalmagick.none");
        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"grimoire.primalmagick.recipe_metadata.discipline").withStyle(ChatFormatting.UNDERLINE), x - 3 + side * 138, y - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.font);
        y += 9;
        if (isEntryMissing) {
            guiGraphics.drawString(mc.font, (Component)noneComponent, x - 3 + side * 138, y - 4, Color.BLACK.getRGB(), false);
        }
        Objects.requireNonNull(mc.font);
        guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"grimoire.primalmagick.recipe_metadata.entry").withStyle(ChatFormatting.UNDERLINE), x - 3 + side * 138, (y += 2 * 9) - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.font);
        y += 9;
        if (isEntryMissing) {
            guiGraphics.drawString(mc.font, (Component)noneComponent, x - 3 + side * 138, y - 4, Color.BLACK.getRGB(), false);
        }
    }

    @Override
    protected Component getTitleText() {
        ItemStack stack = this.recipeHolder.value().getResultItem((HolderLookup.Provider)this.registryAccess);
        return stack.getItem().getName(stack);
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        ResearchEntry entry;
        Minecraft mc = Minecraft.getInstance();
        if (!this.isFirstPage()) {
            y += 24;
        }
        if ((entry = (ResearchEntry)ResearchManager.getEntryForRecipe(this.registryAccess, this.recipeHolder.id()).orElse(null)) != null) {
            Objects.requireNonNull(mc.font);
            int discY = y += 9 + 3;
            entry.disciplineKeyOpt().ifPresent(disciplineKey -> {
                ResearchDiscipline discipline = ResearchDisciplines.getDiscipline(mc.level.registryAccess(), disciplineKey);
                if (discipline != null) {
                    screen.addWidgetToScreen(new DisciplineButton(x + 12 + side * 140, discY, (Component)Component.translatable((String)discipline.getNameTranslationKey()), screen, discipline, false, false));
                }
            });
            Objects.requireNonNull(mc.font);
            screen.addWidgetToScreen(new EntryButton(x + 12 + side * 140, y += 3 * 9, (Component)Component.translatable((String)entry.getNameTranslationKey()), screen, entry, false));
        }
    }
}

