/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.grimoire.IPageElement;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class PageImage
implements IPageElement {
    public int x;
    public int y;
    public int width;
    public int height;
    public int adjustedWidth;
    public int adjustedHeight;
    public float scale;
    public ResourceLocation location;

    @Nullable
    public static PageImage parse(String str) {
        String[] tokens = str.split(":");
        if (tokens.length != 7) {
            return null;
        }
        try {
            PageImage image = new PageImage();
            image.location = ResourceLocation.fromNamespaceAndPath((String)tokens[0], (String)tokens[1]);
            image.x = Integer.parseInt(tokens[2]);
            image.y = Integer.parseInt(tokens[3]);
            image.width = Integer.parseInt(tokens[4]);
            image.height = Integer.parseInt(tokens[5]);
            image.scale = Float.parseFloat(tokens[6]);
            image.adjustedWidth = (int)((float)image.width * image.scale);
            image.adjustedHeight = (int)((float)image.height * image.scale);
            if (image.adjustedWidth > 208 || image.adjustedHeight > 140) {
                return null;
            }
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(x - 15 + side * 152 + (124 - this.adjustedWidth) / 2), (float)(y - 5), 0.0f);
        guiGraphics.pose().scale(this.scale, this.scale, this.scale);
        guiGraphics.blit(this.location, 0, 0, this.x, this.y, this.width, this.height);
        guiGraphics.pose().popPose();
    }

    @Override
    public int getHeight() {
        return this.adjustedHeight + 2;
    }
}

