/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class LinguisticsScorePage
extends AbstractPage {
    protected final Holder<BookLanguage> language;

    public LinguisticsScorePage(Holder<BookLanguage> language) {
        this.language = language;
    }

    @Override
    protected Component getTitleText() {
        return ((BookLanguage)this.language.value()).getName();
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        MutableComponent scoreText;
        this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, null);
        y += 53;
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.getInstance();
        MutableComponent compHeader = Component.translatable((String)"grimoire.primalmagick.linguistics_data.comprehension_score_header").withStyle(ChatFormatting.UNDERLINE);
        guiGraphics.drawString(mc.font, (Component)compHeader, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.font);
        y += 9;
        if (((BookLanguage)this.language.value()).complexity() > 0 && !((BookLanguage)this.language.value()).autoTranslate()) {
            int currentComp = LinguisticsManager.getComprehension((Player)mc.player, this.language);
            int compRating = Mth.clamp((int)((int)((double)currentComp / (double)((BookLanguage)this.language.value()).complexity() * 4.0)), (int)0, (int)4);
            MutableComponent ratingText = Component.translatable((String)("grimoire.primalmagick.linguistics_data.comprehension_rating." + compRating));
            scoreText = Component.translatable((String)"grimoire.primalmagick.linguistics_data.comprehension_score", (Object[])new Object[]{currentComp, ((BookLanguage)this.language.value()).complexity(), ratingText});
        } else {
            scoreText = Component.translatable((String)"grimoire.primalmagick.linguistics_data.comprehension_score.unreadable");
        }
        guiGraphics.drawString(mc.font, (Component)scoreText, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.font);
        y += 9;
        Objects.requireNonNull(mc.font);
        MutableComponent vocabHeader = Component.translatable((String)"grimoire.primalmagick.linguistics_data.vocabulary_score_header").withStyle(ChatFormatting.UNDERLINE);
        guiGraphics.drawString(mc.font, (Component)vocabHeader, x - 3 + side * 140, (y += 9) - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.font);
        MutableComponent vocabText = ((BookLanguage)this.language.value()).complexity() > 0 && !((BookLanguage)this.language.value()).autoTranslate() ? Component.literal((String)Integer.toString(LinguisticsManager.getVocabulary((Player)mc.player, this.language))) : Component.translatable((String)"grimoire.primalmagick.linguistics_data.comprehension_score.unreadable");
        guiGraphics.drawString(mc.font, (Component)vocabText, x - 3 + side * 140, (y += 9) - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.font);
        y += 9;
        guiGraphics.pose().popPose();
    }
}

