/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IngredientWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemStackWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ManaCostSummaryWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RecipeTypeWidget;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class DissolutionRecipePage
extends AbstractRecipePage {
    protected RecipeHolder<IDissolutionRecipe> recipe;

    public DissolutionRecipePage(RecipeHolder<IDissolutionRecipe> recipe, RegistryAccess registryAccess) {
        super(registryAccess);
        this.recipe = recipe;
    }

    @Override
    protected Component getTitleText() {
        ItemStack stack = ((IDissolutionRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.registryAccess);
        return stack.getItem().getName(stack);
    }

    @Override
    protected String getRecipeTypeTranslationKey() {
        return "grimoire.primalmagick.dissolution_recipe_header";
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        int indent = 124;
        int overlayWidth = 51;
        if (!((IDissolutionRecipe)this.recipe.value()).getManaCosts().isEmpty()) {
            screen.addWidgetToScreen(new ManaCostSummaryWidget(((IDissolutionRecipe)this.recipe.value()).getManaCosts(), x + 75 + side * 140 + indent / 2 - overlayWidth / 2, y + 30));
        }
        ItemStack output = ((IDissolutionRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.registryAccess);
        screen.addWidgetToScreen(new ItemStackWidget(output, x + 27 + side * 140 + indent / 2 - overlayWidth / 2, y + 30, false));
        screen.addWidgetToScreen(new RecipeTypeWidget(this.recipe.value(), x - 22 + side * 140 + indent / 2 - overlayWidth / 2, y + 30, (Component)Component.translatable((String)this.getRecipeTypeTranslationKey())));
        screen.addWidgetToScreen(new IngredientWidget((Ingredient)((IDissolutionRecipe)this.recipe.value()).getIngredients().get(0), x - 5 + side * 140 + indent / 2 - overlayWidth / 2 + 32, y + 67 + 27, screen));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        super.render(guiGraphics, side, x, y, mouseX, mouseY);
        y += 53;
        int indent = 124;
        int overlayWidth = 46;
        int overlayHeight = 46;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.pose().translate((float)(x - 6 + side * 140 + indent / 2), (float)(y + 49 + overlayHeight / 2), 0.0f);
        guiGraphics.pose().scale(2.0f, 2.0f, 1.0f);
        guiGraphics.blit(OVERLAY, -(overlayWidth / 2), -(overlayHeight / 2), 97, 0, overlayWidth, overlayHeight);
        guiGraphics.pose().popPose();
    }
}

