/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.EntryButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.MarkReadButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.SectionHeaderWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.UpcomingEntryWidget;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class DisciplinePage
extends AbstractPage {
    protected ResearchDiscipline discipline;
    protected List<Object> contents = new ArrayList<Object>();
    protected boolean firstPage;

    public DisciplinePage(@Nonnull ResearchDiscipline discipline) {
        this(discipline, false);
    }

    public DisciplinePage(@Nonnull ResearchDiscipline discipline, boolean first) {
        this.discipline = discipline;
        this.firstPage = first;
    }

    @Nonnull
    public List<Object> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public boolean addContent(Object entry) {
        return this.contents.add(entry);
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    @Override
    protected Component getTitleText() {
        return Component.translatable((String)this.discipline.getNameTranslationKey());
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        if (this.isFirstPage() && side == 0) {
            this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, this.discipline.iconLocation());
        }
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        if (this.isFirstPage() && this.discipline.isUnread((Player)mc.player)) {
            screen.addWidgetToScreen(new MarkReadButton(x + 8 + side * 140, y - 21, screen, this.discipline));
        }
        for (Object obj : this.getContents()) {
            if (obj instanceof ResearchEntry) {
                ResearchEntry entry = (ResearchEntry)obj;
                MutableComponent text = Component.translatable((String)entry.getNameTranslationKey());
                if (entry.isAvailable((Player)mc.player) && !entry.flags().internal()) {
                    screen.addWidgetToScreen(new EntryButton(x + 12 + side * 140, y, (Component)text, screen, entry, true));
                } else {
                    screen.addWidgetToScreen(new UpcomingEntryWidget(x + 12 + side * 140, y, (Component)text, entry, true));
                }
            } else if (obj instanceof Component) {
                Component comp = (Component)obj;
                screen.addWidgetToScreen(new SectionHeaderWidget(x + 12 + side * 140, y, comp));
            }
            y += 12;
        }
    }
}

