/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.DisciplineButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.MarkReadButton;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class DisciplineIndexPage
extends AbstractPage {
    protected List<ResearchDiscipline> contents = new ArrayList<ResearchDiscipline>();
    protected boolean firstPage;

    public DisciplineIndexPage() {
        this(false);
    }

    public DisciplineIndexPage(boolean first) {
        this.firstPage = first;
    }

    @Nonnull
    public List<ResearchDiscipline> getDisciplines() {
        return Collections.unmodifiableList(this.contents);
    }

    public boolean addDiscipline(ResearchDiscipline discipline) {
        return this.contents.add(discipline);
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    @Override
    protected Component getTitleText() {
        return Component.translatable((String)"grimoire.primalmagick.index_header");
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        if (this.isFirstPage() && side == 0) {
            this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, null);
        }
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        Minecraft mc = Minecraft.getInstance();
        if (this.isFirstPage() && ResearchDisciplines.stream(mc.player.registryAccess()).anyMatch(d -> d.isUnread((Player)mc.player))) {
            screen.addWidgetToScreen(new MarkReadButton(x + 8 + side * 140, y - 21, screen));
        }
        for (ResearchDiscipline discipline : this.getDisciplines()) {
            MutableComponent text = Component.translatable((String)discipline.getNameTranslationKey());
            DisciplineButton button = screen.addWidgetToScreen(new DisciplineButton(x + 12 + side * 140, y, (Component)text, screen, discipline, true, true));
            y += button.getHeight();
        }
    }
}

