/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractPage
implements GuiEventListener {
    private static final ResourceLocation GRIMOIRE_TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");

    public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract Component getTitleText();

    public abstract void initWidgets(GrimoireScreen var1, int var2, int var3, int var4);

    protected boolean renderTopTitleBar() {
        return true;
    }

    protected void renderTitle(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY, @Nullable ResourceLocation icon) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft mc = Minecraft.getInstance();
        if (this.renderTopTitleBar()) {
            guiGraphics.blit(GRIMOIRE_TEXTURE, x + 10 + side * 140, y + 18, 24, 184, 96, 5);
        }
        guiGraphics.blit(GRIMOIRE_TEXTURE, x + 10 + side * 140, y + 35, 24, 184, 96, 5);
        Component headerText = this.getTitleText();
        int width = mc.font.width(headerText.getString());
        int indent = 124;
        if (width <= 124) {
            guiGraphics.drawString(mc.font, headerText, x - 3 + side * 140 + indent / 2 - width / 2, y + 25, Color.BLACK.getRGB(), false);
            if (icon != null) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(x - 3 + side * 140 + indent / 2 - width / 2 - 17), (float)(y + 21), 0.0f);
                guiGraphics.pose().scale(0.06f, 0.06f, 0.06f);
                guiGraphics.blit(icon, 0, 0, 0, 0, 255, 255);
                guiGraphics.pose().popPose();
            }
        } else {
            float scale = 124.0f / (float)width;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(x - 3 + side * 140 + indent / 2) - (float)(width / 2) * scale, (float)(y + 25) + 1.0f * scale, 0.0f);
            guiGraphics.pose().scale(scale, scale, scale);
            guiGraphics.drawString(mc.font, headerText, 0, 0, Color.BLACK.getRGB(), false);
            if (icon != null) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)(x - 3 + side * 140 + indent / 2) - (float)(width / 2) * scale - 17.0f, (float)(y + 21), 0.0f);
                guiGraphics.pose().scale(0.06f, 0.06f, 0.06f);
                guiGraphics.blit(icon, 0, 0, 0, 0, 255, 255);
                guiGraphics.pose().popPose();
            }
            guiGraphics.pose().popPose();
        }
    }

    public void setFocused(boolean pFocused) {
    }

    public boolean isFocused() {
        return false;
    }

    public void tick() {
    }
}

