/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.AbstractContainerScreenPM;
import com.verdantartifice.primalmagick.client.gui.widgets.ManaCostWidget;
import com.verdantartifice.primalmagick.common.menus.SpellcraftingAltarMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.spellcrafting.SetSpellComponentPropertyPacket;
import com.verdantartifice.primalmagick.common.network.packets.spellcrafting.SetSpellComponentTypeIndexPacket;
import com.verdantartifice.primalmagick.common.network.packets.spellcrafting.SetSpellNamePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.SpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SpellcraftingAltarScreen
extends AbstractContainerScreenPM<SpellcraftingAltarMenu> {
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/spellcrafting_altar.png");
    private final Map<Vec3i, Component> texts = new HashMap<Vec3i, Component>();
    private final List<GuiEventListener> localWidgets = new ArrayList<GuiEventListener>();
    private EditBox nameField;

    public SpellcraftingAltarScreen(SpellcraftingAltarMenu screenMenu, Inventory inv, Component titleIn) {
        super(screenMenu, inv, titleIn);
        this.imageWidth = 230;
        this.imageHeight = 222;
    }

    protected void init() {
        super.init();
        this.nameField = new EditBox(this.font, this.leftPos + 49, this.topPos + 12, 103, 12, (Component)Component.empty());
        this.nameField.setCanLoseFocus(false);
        this.nameField.setFocused(true);
        this.nameField.setTextColor(-1);
        this.nameField.setTextColorUneditable(-1);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(50);
        this.nameField.setResponder(this::updateName);
        this.nameField.setValue(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        this.addWidget((GuiEventListener)this.nameField);
        this.setInitialFocus((GuiEventListener)this.nameField);
    }

    public void resize(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String str = this.nameField.getValue();
        this.init(p_resize_1_, p_resize_2_, p_resize_3_);
        this.nameField.setValue(str);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.minecraft.player.closeContainer();
        }
        return !this.nameField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.nameField.canConsumeInput() ? super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    protected void regenerateWidgets() {
        for (GuiEventListener widget : this.localWidgets) {
            this.removeWidget(widget);
        }
        this.localWidgets.clear();
        this.texts.clear();
        if (!this.nameField.isFocused()) {
            this.setInitialFocus((GuiEventListener)this.nameField);
        }
        int startX = this.leftPos + 7;
        int startY = this.topPos + 32;
        int x = startX;
        int y = startY;
        int vehicleMax = SpellManager.getVehicleTypes(((SpellcraftingAltarMenu)this.menu).getPlayer()).size() - 1;
        int payloadMax = SpellManager.getPayloadTypes(((SpellcraftingAltarMenu)this.menu).getPlayer()).size() - 1;
        int modMax = SpellManager.getModTypes(((SpellcraftingAltarMenu)this.menu).getPlayer()).size() - 1;
        SourceList manaCost = ((SpellcraftingAltarMenu)this.menu).getSpellPackage().getManaCost();
        if (!manaCost.isEmpty()) {
            Source source = manaCost.getSourcesSorted().get(0);
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new ManaCostWidget(source, manaCost.getAmount(source), this.leftPos + 28, this.topPos + 8, ((SpellcraftingAltarMenu)this.menu)::getWand, ((SpellcraftingAltarMenu)this.menu).getPlayer())));
        }
        this.texts.put(new Vec3i(x, y + 2, 106), (Component)Component.translatable((String)"spells.primalmagick.vehicle.header"));
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, vehicleMax, ((SpellcraftingAltarMenu)this.menu)::getSpellVehicleTypeIndex, this::updateSpellVehicleTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((AbstractSpellVehicle)((SpellcraftingAltarMenu)this.menu).getSpellPackage().vehicle().getComponent()).getTypeName());
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, vehicleMax, ((SpellcraftingAltarMenu)this.menu)::getSpellVehicleTypeIndex, this::updateSpellVehicleTypeIndex)));
        for (SpellProperty property : ((AbstractSpellVehicle)((SpellcraftingAltarMenu)this.menu).getSpellPackage().vehicle().getComponent()).getProperties()) {
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().vehicle().getPropertyValue(property), v -> this.updateSpellPropertyValue(SpellComponent.VEHICLE, property, (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.literal((String)Integer.toString(((SpellcraftingAltarMenu)this.menu).getSpellPackage().vehicle().getPropertyValue(property))));
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().vehicle().getPropertyValue(property), v -> this.updateSpellPropertyValue(SpellComponent.VEHICLE, property, (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.font.width(property.getDescription().getString()))), property.getDescription());
        }
        y = startY + 48;
        this.texts.put(new Vec3i(x, y + 2, 106), (Component)Component.translatable((String)"spells.primalmagick.payload.header"));
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, payloadMax, ((SpellcraftingAltarMenu)this.menu)::getSpellPayloadTypeIndex, this::updateSpellPayloadTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((AbstractSpellPayload)((SpellcraftingAltarMenu)this.menu).getSpellPackage().payload().getComponent()).getTypeName());
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, payloadMax, ((SpellcraftingAltarMenu)this.menu)::getSpellPayloadTypeIndex, this::updateSpellPayloadTypeIndex)));
        for (SpellProperty property : ((AbstractSpellPayload)((SpellcraftingAltarMenu)this.menu).getSpellPackage().payload().getComponent()).getProperties()) {
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().payload().getPropertyValue(property), v -> this.updateSpellPropertyValue(SpellComponent.PAYLOAD, property, (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.literal((String)Integer.toString(((SpellcraftingAltarMenu)this.menu).getSpellPackage().payload().getPropertyValue(property))));
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().payload().getPropertyValue(property), v -> this.updateSpellPropertyValue(SpellComponent.PAYLOAD, property, (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.font.width(property.getDescription().getString()))), property.getDescription());
        }
        y = startY;
        this.texts.put(new Vec3i(x += 110, y + 2, 106), (Component)Component.translatable((String)"spells.primalmagick.primary_mod.header"));
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, modMax, ((SpellcraftingAltarMenu)this.menu)::getSpellPrimaryModTypeIndex, this::updateSpellPrimaryModTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((SpellcraftingAltarMenu)this.menu).getSpellPackage().primaryMod().map(mod -> ((AbstractSpellMod)mod.getComponent()).getTypeName()).orElseGet(Component::empty));
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, modMax, ((SpellcraftingAltarMenu)this.menu)::getSpellPrimaryModTypeIndex, this::updateSpellPrimaryModTypeIndex)));
        for (SpellProperty property : ((SpellcraftingAltarMenu)this.menu).getSpellPackage().primaryMod().map(mod -> ((AbstractSpellMod)mod.getComponent()).getProperties()).orElseGet(ImmutableList::of)) {
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().primaryMod().map(mod -> mod.getPropertyValue(property)).orElse(0), v -> this.updateSpellPropertyValue(SpellComponent.PRIMARY_MOD, property, (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.literal((String)Integer.toString(((SpellcraftingAltarMenu)this.menu).getSpellPackage().primaryMod().map(mod -> mod.getPropertyValue(property)).orElse(0))));
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().primaryMod().map(mod -> mod.getPropertyValue(property)).orElse(0), v -> this.updateSpellPropertyValue(SpellComponent.PRIMARY_MOD, property, (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.font.width(property.getDescription().getString()))), property.getDescription());
        }
        y = startY + 48;
        this.texts.put(new Vec3i(x, y + 2, 106), (Component)Component.translatable((String)"spells.primalmagick.secondary_mod.header"));
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x, y += 12, false, 0, modMax, ((SpellcraftingAltarMenu)this.menu)::getSpellSecondaryModTypeIndex, this::updateSpellSecondaryModTypeIndex)));
        this.texts.put(new Vec3i(x + 8, y + 2, 90), ((SpellcraftingAltarMenu)this.menu).getSpellPackage().secondaryMod().map(mod -> ((AbstractSpellMod)mod.getComponent()).getTypeName()).orElseGet(Component::empty));
        this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 99, y, true, 0, modMax, ((SpellcraftingAltarMenu)this.menu)::getSpellSecondaryModTypeIndex, this::updateSpellSecondaryModTypeIndex)));
        for (SpellProperty property : ((SpellcraftingAltarMenu)this.menu).getSpellPackage().secondaryMod().map(mod -> ((AbstractSpellMod)mod.getComponent()).getProperties()).orElseGet(ImmutableList::of)) {
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 8, y += 12, false, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().secondaryMod().map(mod -> mod.getPropertyValue(property)).orElse(0), v -> this.updateSpellPropertyValue(SpellComponent.SECONDARY_MOD, property, (int)v))));
            this.texts.put(new Vec3i(x + 18, y + 2, 7), (Component)Component.literal((String)Integer.toString(((SpellcraftingAltarMenu)this.menu).getSpellPackage().secondaryMod().map(mod -> mod.getPropertyValue(property)).orElse(0))));
            this.localWidgets.add(this.addRenderableWidget((GuiEventListener)new CyclicBoundedSpinnerButton(x + 26, y, true, property.min(), property.max(), () -> ((SpellcraftingAltarMenu)this.menu).getSpellPackage().secondaryMod().map(mod -> mod.getPropertyValue(property)).orElse(0), v -> this.updateSpellPropertyValue(SpellComponent.SECONDARY_MOD, property, (int)v))));
            this.texts.put(new Vec3i(x + 35, y + 2, Math.min(71, this.font.width(property.getDescription().getString()))), property.getDescription());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.regenerateWidgets();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
        this.nameField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(TEXTURE, this.leftPos + 46, this.topPos + 8, 0, this.imageHeight, 110, 16);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int color = 0x404040;
        for (Map.Entry<Vec3i, Component> entry : this.texts.entrySet()) {
            String str = this.font.plainSubstrByWidth(entry.getValue().getString(), entry.getKey().getZ());
            int strWidth = this.font.width(str);
            guiGraphics.drawString(this.minecraft.font, str, entry.getKey().getX() - this.leftPos + (entry.getKey().getZ() - strWidth) / 2, entry.getKey().getY() - this.topPos, color, false);
        }
    }

    private void updateName(String name) {
        if (name.isEmpty()) {
            name = ((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString();
        }
        ((SpellcraftingAltarMenu)this.menu).setSpellName(name);
        PacketHandler.sendToServer(new SetSpellNamePacket(((SpellcraftingAltarMenu)this.menu).containerId, name));
    }

    private void updateSpellVehicleTypeIndex(int index) {
        boolean recalcName = this.nameField.getValue().isEmpty() || this.nameField.getValue().equals(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.menu).setSpellVehicleTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.menu).containerId, SpellComponent.VEHICLE, index));
        if (recalcName) {
            this.nameField.setValue(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        }
    }

    private void updateSpellPayloadTypeIndex(int index) {
        boolean recalcName = this.nameField.getValue().isEmpty() || this.nameField.getValue().equals(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.menu).setSpellPayloadTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.menu).containerId, SpellComponent.PAYLOAD, index));
        if (recalcName) {
            this.nameField.setValue(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        }
    }

    private void updateSpellPrimaryModTypeIndex(int index) {
        boolean recalcName = this.nameField.getValue().isEmpty() || this.nameField.getValue().equals(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.menu).setSpellPrimaryModTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.menu).containerId, SpellComponent.PRIMARY_MOD, index));
        if (recalcName) {
            this.nameField.setValue(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        }
    }

    private void updateSpellSecondaryModTypeIndex(int index) {
        boolean recalcName = this.nameField.getValue().isEmpty() || this.nameField.getValue().equals(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        ((SpellcraftingAltarMenu)this.menu).setSpellSecondaryModTypeIndex(index);
        PacketHandler.sendToServer(new SetSpellComponentTypeIndexPacket(((SpellcraftingAltarMenu)this.menu).containerId, SpellComponent.SECONDARY_MOD, index));
        if (recalcName) {
            this.nameField.setValue(((SpellcraftingAltarMenu)this.menu).getDefaultSpellName().getString());
        }
    }

    private void updateSpellPropertyValue(SpellComponent component, SpellProperty property, int value) {
        ((SpellcraftingAltarMenu)this.menu).setSpellPropertyValue(component, property, value);
        PacketHandler.sendToServer(new SetSpellComponentPropertyPacket(((SpellcraftingAltarMenu)this.menu).containerId, component, property, value));
    }

    protected static class CyclicBoundedSpinnerButton
    extends Button {
        protected final boolean isIncrement;
        protected final int min;
        protected final int max;
        protected final Supplier<Integer> getter;
        protected final Consumer<Integer> setter;

        public CyclicBoundedSpinnerButton(int x, int y, boolean increment, int min, int max, Supplier<Integer> getter, Consumer<Integer> setter) {
            super(x, y, 7, 11, (Component)Component.empty(), (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
            this.isIncrement = increment;
            this.min = min;
            this.max = max;
            this.getter = getter;
            this.setter = setter;
        }

        public void renderWidget(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            guiGraphics.blit(TEXTURE, this.getX(), this.getY(), this.isIncrement ? 230 : 237, this.isHoveredOrFocused() ? 11 : 0, this.width, this.height);
        }

        public boolean isIncrement() {
            return this.isIncrement;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public Supplier<Integer> getGetter() {
            return this.getter;
        }

        public Consumer<Integer> getSetter() {
            return this.setter;
        }

        private static class Handler
        implements Button.OnPress {
            private Handler() {
            }

            public void onPress(Button button) {
                if (button instanceof CyclicBoundedSpinnerButton) {
                    CyclicBoundedSpinnerButton spinner = (CyclicBoundedSpinnerButton)button;
                    int newVal = spinner.getGetter().get() + (spinner.isIncrement() ? 1 : -1);
                    if (newVal < spinner.getMin()) {
                        newVal = spinner.getMax();
                    } else if (newVal > spinner.getMax()) {
                        newVal = spinner.getMin();
                    }
                    spinner.getSetter().accept(newVal);
                }
            }
        }
    }
}

