/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.client.gui.AbstractContainerScreenPM;
import com.verdantartifice.primalmagick.client.gui.widgets.InactiveWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.AidListWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.AidUnlockWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.KnowledgeTotalWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.OtherRewardWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.ProjectMaterialSelectionCheckbox;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.ProjectMaterialWidgetFactory;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.menus.ResearchTableMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.theorycrafting.CompleteProjectPacket;
import com.verdantartifice.primalmagick.common.network.packets.theorycrafting.SetProjectMaterialSelectionPacket;
import com.verdantartifice.primalmagick.common.network.packets.theorycrafting.StartProjectPacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.theorycrafting.MaterialInstance;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class ResearchTableScreen
extends AbstractContainerScreenPM<ResearchTableMenu> {
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/research_table.png");
    private static final ResourceLocation OVERLAY = ResourceUtils.loc("textures/gui/research_table_overlay.png");
    private static final DecimalFormat FORMATTER = new DecimalFormat("###.#");
    protected long lastCheck = 0L;
    protected boolean progressing = false;
    protected boolean writingReady = false;
    protected boolean lastWritingReady = false;
    protected IPlayerKnowledge knowledge;
    protected Project project = null;
    protected Project lastProject = null;
    protected Button completeProjectButton = null;

    public ResearchTableScreen(ResearchTableMenu screenMenu, Inventory inv, Component titleIn) {
        super(screenMenu, inv, titleIn);
        this.imageWidth = 230;
        this.imageHeight = 222;
    }

    protected void init() {
        super.init();
        Minecraft mc = Minecraft.getInstance();
        this.knowledge = Services.CAPABILITIES.knowledge((Player)mc.player).orElseThrow(() -> new IllegalStateException("No knowledge provider found for player"));
        this.project = this.knowledge.getActiveResearchProject();
        this.lastWritingReady = this.writingReady = ((ResearchTableMenu)this.menu).isWritingReady();
        this.initButtons();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        long millis = System.currentTimeMillis();
        this.lastWritingReady = this.writingReady;
        this.writingReady = ((ResearchTableMenu)this.menu).isWritingReady();
        if (millis > this.lastCheck || this.lastWritingReady != this.writingReady) {
            this.lastCheck = this.progressing ? millis + 250L : millis + 2000L;
            this.lastProject = this.project;
            this.project = this.knowledge.getActiveResearchProject();
            if (this.lastProject != this.project) {
                this.progressing = false;
            }
            this.initButtons();
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        if (this.isProjectReady()) {
            int y = 11;
            MutableComponent titleText = Component.translatable((String)this.project.getNameTranslationKey()).withStyle(ChatFormatting.BOLD);
            int titleWidth = mc.font.width((FormattedText)titleText);
            guiGraphics.drawString(mc.font, (Component)titleText, 34 + (162 - titleWidth) / 2, y, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.font);
            y += (int)(9.0 * 1.66);
            MutableComponent descText = Component.translatable((String)this.project.getTextTranslationKey());
            List descLines = mc.font.getSplitter().splitLines((FormattedText)descText, 154, Style.EMPTY);
            for (FormattedText line : descLines) {
                guiGraphics.drawString(mc.font, line.getString(), 38, y, Color.BLACK.getRGB(), false);
                Objects.requireNonNull(mc.font);
                y += 9;
            }
        } else if (!((ResearchTableMenu)this.menu).isWritingReady()) {
            MutableComponent text = Component.translatable((String)"label.primalmagick.research_table.missing_writing_supplies");
            int width = mc.font.width(text.getString());
            Font font = mc.font;
            int n = 34 + (162 - width) / 2;
            Objects.requireNonNull(mc.font);
            guiGraphics.drawString(font, (Component)text, n, 7 + (128 - 9) / 2, Color.BLACK.getRGB(), false);
        } else {
            MutableComponent text = Component.translatable((String)"label.primalmagick.research_table.ready");
            int width = mc.font.width(text.getString());
            Font font = mc.font;
            int n = 34 + (162 - width) / 2;
            Objects.requireNonNull(mc.font);
            guiGraphics.drawString(font, (Component)text, n, 7 + (128 - 9) / 2, Color.BLACK.getRGB(), false);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.isProjectReady()) {
            guiGraphics.blit(OVERLAY, this.leftPos + 34, this.topPos + 7, 0, 0, 162, 128);
        }
    }

    protected boolean isProjectReady() {
        return this.project != null && ((ResearchTableMenu)this.menu).isWritingReady();
    }

    public void setProgressing() {
        this.progressing = true;
        this.lastCheck = 0L;
    }

    public void setMaterialSelection(int index, boolean selected) {
        if (this.project != null && index >= 0 && index < this.project.activeMaterials().size()) {
            this.project.activeMaterials().get(index).setSelected(selected);
            PacketHandler.sendToServer(new SetProjectMaterialSelectionPacket(index, selected));
            this.lastCheck = 0L;
        }
    }

    protected void initButtons() {
        this.clearWidgets();
        this.completeProjectButton = null;
        if (this.project == null && ((ResearchTableMenu)this.menu).isWritingReady()) {
            this.addRenderableWidget((GuiEventListener)new KnowledgeTotalWidget(this.leftPos + 203, this.topPos + 116, KnowledgeType.THEORY));
            if (this.progressing) {
                MutableComponent text = Component.translatable((String)"label.primalmagick.research_table.starting");
                this.addRenderableWidget((GuiEventListener)new InactiveWidget(this.leftPos + 38, this.topPos + 111, 154, 20, (Component)text));
            } else {
                MutableComponent text = Component.translatable((String)"label.primalmagick.research_table.start");
                this.addRenderableWidget((GuiEventListener)new StartProjectButton(this.leftPos + 38, this.topPos + 111, (Component)text, this));
            }
        } else if (this.isProjectReady()) {
            this.addRenderableWidget((GuiEventListener)new KnowledgeTotalWidget(this.leftPos + 203, this.topPos + 116, KnowledgeType.THEORY, OptionalInt.of(this.project.getTheoryPointReward())));
            if (!this.project.otherRewards().isEmpty()) {
                this.addRenderableWidget((GuiEventListener)new OtherRewardWidget(this.project.otherRewards(), this.leftPos + 203, this.topPos + 97));
            }
            if (this.progressing) {
                MutableComponent text = Component.translatable((String)"label.primalmagick.research_table.completing");
                this.addRenderableWidget((GuiEventListener)new InactiveWidget(this.leftPos + 38, this.topPos + 111, 154, 20, (Component)text));
            } else {
                ((ResearchTableMenu)this.menu).getContainerLevelAccess().execute((level, tablePos) -> {
                    Object material;
                    LocalPlayer player = this.minecraft.player;
                    double chance = 100.0 * this.project.getSuccessChance();
                    Set<Block> surroundings = TheorycraftManager.getSurroundings(level, tablePos);
                    MutableComponent text = Component.translatable((String)"label.primalmagick.research_table.complete", (Object[])new Object[]{FORMATTER.format(chance)});
                    this.completeProjectButton = (Button)this.addRenderableWidget((GuiEventListener)new CompleteProjectButton(this.leftPos + 38, this.topPos + 111, (Component)text, this));
                    this.completeProjectButton.active = this.project.isSatisfied((Player)player, surroundings);
                    List<Component> aidNames = ((ResearchTableMenu)this.menu).getNearbyAidBlockNames();
                    if (!aidNames.isEmpty()) {
                        this.addRenderableWidget((GuiEventListener)new AidListWidget(this.leftPos + 36, this.topPos + 9, aidNames));
                    }
                    this.project.getAidBlock().ifPresent(aid -> this.addRenderableWidget((GuiEventListener)new AidUnlockWidget(this.leftPos + 186, this.topPos + 9, (Block)aid)));
                    int materialCount = this.project.activeMaterials().size();
                    int startX = (152 - 38 * materialCount) / 2;
                    int index = 0;
                    int x = startX;
                    while (index < materialCount) {
                        material = this.project.activeMaterials().get(index);
                        this.addRenderableWidget((GuiEventListener)new ProjectMaterialSelectionCheckbox(this.leftPos + 42 + x, this.topPos + 93, this, ((MaterialInstance)material).isSelected(), index));
                        ++index;
                        x += 38;
                    }
                    index = 0;
                    x = startX;
                    while (index < materialCount) {
                        material = this.project.activeMaterials().get(index).getMaterialDefinition();
                        this.addRenderableWidget((GuiEventListener)ProjectMaterialWidgetFactory.create(material, this.leftPos + 58 + x, this.topPos + 93, surroundings));
                        ++index;
                        x += 38;
                    }
                });
            }
        }
        this.addRenderableWidget((GuiEventListener)new KnowledgeTotalWidget(this.leftPos + 11, this.topPos + 116, KnowledgeType.OBSERVATION));
    }

    protected static class StartProjectButton
    extends Button {
        protected ResearchTableScreen screen;

        public StartProjectButton(int xIn, int yIn, Component text, ResearchTableScreen screen) {
            super(xIn, yIn, 154, 20, text, (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
            this.screen = screen;
        }

        public ResearchTableScreen getScreen() {
            return this.screen;
        }

        private static class Handler
        implements Button.OnPress {
            private Handler() {
            }

            public void onPress(Button button) {
                if (button instanceof StartProjectButton) {
                    StartProjectButton spb = (StartProjectButton)button;
                    PacketHandler.sendToServer(new StartProjectPacket(((ResearchTableMenu)((ResearchTableScreen)spb.getScreen()).menu).containerId));
                    spb.getScreen().setProgressing();
                }
            }
        }
    }

    protected static class CompleteProjectButton
    extends Button {
        protected ResearchTableScreen screen;

        public CompleteProjectButton(int xIn, int yIn, Component text, ResearchTableScreen screen) {
            super(xIn, yIn, 154, 20, text, (Button.OnPress)new Handler(), Button.DEFAULT_NARRATION);
            this.screen = screen;
        }

        public ResearchTableScreen getScreen() {
            return this.screen;
        }

        private static class Handler
        implements Button.OnPress {
            private Handler() {
            }

            public void onPress(Button button) {
                if (button instanceof CompleteProjectButton) {
                    CompleteProjectButton cpb = (CompleteProjectButton)button;
                    PacketHandler.sendToServer(new CompleteProjectPacket(((ResearchTableMenu)((ResearchTableScreen)cpb.getScreen()).menu).containerId));
                    cpb.getScreen().setProgressing();
                }
            }
        }
    }
}

