/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.client.gui.AbstractContainerScreenPM;
import com.verdantartifice.primalmagick.client.gui.widgets.ManaGaugeWidget;
import com.verdantartifice.primalmagick.common.menus.ManaBatteryMenu;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class ManaBatteryScreen
extends AbstractContainerScreenPM<ManaBatteryMenu> {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/mana_battery.png");
    protected static final int AVAILABLE_GAUGE_WIDTH = 116;
    protected static final int GAUGE_START_X = 57;
    protected static final int GAUGE_WIDTH = 12;
    protected final Map<Source, ManaGaugeWidget> manaGauges = new HashMap<Source, ManaGaugeWidget>();

    public ManaBatteryScreen(ManaBatteryMenu screenMenu, Inventory inv, Component titleIn) {
        super(screenMenu, inv, titleIn);
        this.imageWidth = 230;
        this.imageHeight = 164;
        this.inventoryLabelX = 34;
    }

    protected void init() {
        super.init();
        Minecraft mc = Minecraft.getInstance();
        List<Source> knownSources = Sources.getAllSorted().stream().filter(s -> s.isDiscovered((Player)mc.player)).toList();
        int gapWidth = (116 - 12 * knownSources.size()) / (knownSources.size() - 1);
        int bonusEdge = 116 - 12 * knownSources.size() - gapWidth * (knownSources.size() - 1);
        int xOffset = 57 + bonusEdge / 2;
        for (Source source : knownSources) {
            this.manaGauges.put(source, (ManaGaugeWidget)this.addRenderableWidget((GuiEventListener)new ManaGaugeWidget(this.leftPos + xOffset, this.topPos + 16, source, ((ManaBatteryMenu)this.menu).getCurrentMana(source), ((ManaBatteryMenu)this.menu).getMaxMana(source))));
            xOffset += 12 + gapWidth;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.manaGauges.forEach((source, gauge) -> {
            gauge.setCurrentMana(((ManaBatteryMenu)this.menu).getCurrentMana((Source)source));
            gauge.setMaxMana(((ManaBatteryMenu)this.menu).getMaxMana((Source)source));
        });
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int charge = ((ManaBatteryMenu)this.menu).getChargeProgressionScaled();
        guiGraphics.blit(TEXTURE, this.leftPos + 29, this.topPos + 34, 230, 0, charge + 1, 16);
    }
}

