/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.client.config.KeyBindings;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AffinityIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AffinityPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AttunementGainPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AttunementIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.AttunementPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.DisciplineIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.DisciplinePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.IPageElement;
import com.verdantartifice.primalmagick.client.gui.grimoire.LinguisticsDescriptionPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.LinguisticsIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.LinguisticsScorePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.OtherIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.PageImage;
import com.verdantartifice.primalmagick.client.gui.grimoire.PageString;
import com.verdantartifice.primalmagick.client.gui.grimoire.RecipeIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RecipeMetadataPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RecipePageFactory;
import com.verdantartifice.primalmagick.client.gui.grimoire.RequirementsPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RuneEnchantmentIndexPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RuneEnchantmentPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.StagePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.StatisticsPage;
import com.verdantartifice.primalmagick.client.gui.grimoire.TipsPage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.BackButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.MainIndexButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.PageButton;
import com.verdantartifice.primalmagick.common.affinities.AffinityIndexEntry;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.crafting.IHasRequirement;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SetResearchTopicHistoryPacket;
import com.verdantartifice.primalmagick.common.research.ResearchAddendum;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentKey;
import com.verdantartifice.primalmagick.common.research.keys.RuneEnchantmentPartialKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.AffinityResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.DisciplineResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.EnchantmentResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.EntryResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.LanguageResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.MainIndexResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.OtherResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.SourceResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.TopicLink;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.tips.TipDefinition;
import com.verdantartifice.primalmagick.common.tips.TipDefinitionsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringDecomposer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrimoireScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/grimoire.png");
    private static final PageImage IMAGE_LINE = PageImage.parse("primalmagick:textures/gui/grimoire.png:24:184:95:6:1");
    private static final float SCALE = 1.3f;
    private static final int HISTORY_LIMIT = 64;
    private static final int BG_WIDTH = 256;
    private static final int BG_HEIGHT = 181;
    protected int leftPos;
    protected int topPos;
    protected int scaledLeft;
    protected int scaledTop;
    protected int currentPage = 0;
    protected int currentStageIndex = 0;
    protected int lastStageIndex = 0;
    protected long lastCheck = 0L;
    protected long lastRefresh = 0L;
    protected boolean progressing = false;
    protected boolean refreshing = false;
    protected List<AbstractPage> pages = new ArrayList<AbstractPage>();
    protected IPlayerKnowledge knowledge;
    protected NavigableMap<String, List<RecipeHolder<?>>> indexMap;
    protected Component cachedTip = null;
    protected Optional<String> lastRecipeSearch = Optional.empty();
    protected PageButton nextPageButton;
    protected PageButton prevPageButton;
    protected BackButton backButton;

    public GrimoireScreen() {
        super((Component)Component.empty());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        long millis = System.currentTimeMillis();
        if ((this.isProgressing() || this.isRefreshing() || this.currentStageIndex > this.lastStageIndex) && millis > this.lastCheck) {
            if (this.currentStageIndex > this.lastStageIndex) {
                this.progressing = false;
                this.lastStageIndex = this.currentStageIndex;
                this.currentPage = 0;
                this.updateNavButtonVisibility();
            }
            this.lastCheck = millis + 250L;
            this.initPages();
            this.initButtons();
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void setRefreshing() {
        long millis = System.currentTimeMillis();
        if (millis > this.lastRefresh) {
            this.refreshing = true;
            this.lastCheck = 0L;
            this.lastRefresh = millis + 250L;
        }
    }

    public boolean isProgressing() {
        return this.progressing;
    }

    public void setProgressing() {
        this.progressing = true;
        this.lastCheck = 0L;
        this.lastStageIndex = this.currentStageIndex;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - 256) / 2;
        this.topPos = (this.height - 181) / 2;
        this.scaledLeft = (int)((float)this.width - 332.8f) / 2;
        this.scaledTop = (int)((float)this.height - 235.29999f) / 2;
        Minecraft mc = Minecraft.getInstance();
        this.knowledge = Services.CAPABILITIES.knowledge((Player)mc.player).orElseThrow(() -> new IllegalStateException("No knowledge provider found for player"));
        this.minecraft.getConnection().send((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
        this.generateIndexMap();
        this.setCurrentPage(this.knowledge.getLastResearchTopic().getPage());
        this.initPages();
        this.initButtons();
        PacketHandler.sendToServer(new SetResearchTopicHistoryPacket(this.knowledge.getLastResearchTopic(), this.getHistoryView()));
    }

    protected void initPages() {
        this.pages.clear();
        AbstractResearchTopic<?> topic = this.knowledge.getLastResearchTopic();
        if (topic instanceof MainIndexResearchTopic) {
            this.parseIndexPages();
        } else if (topic instanceof DisciplineResearchTopic) {
            DisciplineResearchTopic discTopic = (DisciplineResearchTopic)topic;
            this.parseDisciplinePages(discTopic.getDiscipline());
        } else if (topic instanceof EntryResearchTopic) {
            EntryResearchTopic entryTopic = (EntryResearchTopic)topic;
            this.parseEntryPages(entryTopic.getEntry());
        } else if (topic instanceof SourceResearchTopic) {
            SourceResearchTopic sourceTopic = (SourceResearchTopic)topic;
            this.parseAttunementPage(sourceTopic.getSource());
        } else if (topic instanceof EnchantmentResearchTopic) {
            EnchantmentResearchTopic enchTopic = (EnchantmentResearchTopic)topic;
            this.parseRuneEnchantmentPage(enchTopic.getEnchantment());
        } else if (topic instanceof LanguageResearchTopic) {
            LanguageResearchTopic langTopic = (LanguageResearchTopic)topic;
            this.parseLinguisticsPage(langTopic.getLanguage());
        } else if (topic instanceof AffinityResearchTopic) {
            AffinityResearchTopic affinityTopic = (AffinityResearchTopic)topic;
            this.parseAffinityPage(affinityTopic.getSource());
        } else if (topic instanceof OtherResearchTopic) {
            OtherResearchTopic otherTopic = (OtherResearchTopic)topic;
            String data = otherTopic.getData();
            if (this.isIndexKey(data)) {
                this.parseRecipeEntryPages(data);
            } else if (StatisticsPage.TOPIC.getData().equals(data)) {
                this.parseStatsPages();
            } else if (AttunementIndexPage.TOPIC.getData().equals(data)) {
                this.parseAttunementIndexPages();
            } else if (RuneEnchantmentIndexPage.TOPIC.getData().equals(data)) {
                this.parseRuneEnchantmentIndexPages();
            } else if (RecipeIndexPage.TOPIC.getData().equals(data)) {
                this.parseRecipeIndexPages();
            } else if (TipsPage.TOPIC.getData().equals(data)) {
                this.parseTipsPages();
            } else if (LinguisticsIndexPage.TOPIC.getData().equals(data)) {
                this.parseLinguisticsIndexPages();
            } else if (AffinityIndexPage.TOPIC.getData().equals(data)) {
                this.parseAffinityIndexPages();
            } else {
                LOGGER.warn("Unexpected OtherResearchTopic data {}", (Object)data);
            }
        } else {
            LOGGER.warn("Unexpected research topic type {}", (Object)topic.getType().toString());
        }
    }

    protected void initButtons() {
        int current = 0;
        this.clearWidgets();
        for (AbstractPage page : this.pages) {
            if ((current == this.currentPage || current == this.currentPage + 1) && current < this.pages.size()) {
                this.initPageButtons(page, current % 2, this.scaledLeft + 23, this.scaledTop + 9);
            }
            if (++current <= this.currentPage + 1) continue;
            break;
        }
        this.nextPageButton = new PageButton(this.leftPos + 258, this.topPos + 172, this, true);
        this.prevPageButton = new PageButton(this.leftPos - 12, this.topPos + 172, this, false);
        this.backButton = new BackButton(this.leftPos + 120, this.topPos + 172, this);
        this.addRenderableWidget((GuiEventListener)this.nextPageButton);
        this.addRenderableWidget((GuiEventListener)this.prevPageButton);
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.addRenderableWidget((GuiEventListener)new MainIndexButton(this.leftPos + 142, this.topPos + 177, this));
        this.updateNavButtonVisibility();
    }

    public <T extends AbstractWidget> T addWidgetToScreen(T widget) {
        return (T)((AbstractWidget)this.addRenderableWidget((GuiEventListener)widget));
    }

    private void initPageButtons(AbstractPage abstractPage, int side, int x, int y) {
        if (this.currentPage == 0 && side == 0) {
            y += 53;
        }
        if (this.currentPage > 0 || side == 1) {
            y += 29;
        }
        abstractPage.initWidgets(this, side, x, y);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.scaledLeft, (float)this.scaledTop, 0.0f);
        guiGraphics.pose().scale(1.3f, 1.3f, 1.0f);
        guiGraphics.blit(TEXTURE, 0, 0, 0, 0, 256, 181);
        guiGraphics.pose().popPose();
        int current = 0;
        for (AbstractPage page : this.pages) {
            if ((current == this.currentPage || current == this.currentPage + 1) && current < this.pages.size()) {
                page.render(guiGraphics, current % 2, this.leftPos, this.topPos - 10, mouseX, mouseY);
            }
            if (++current <= this.currentPage + 1) continue;
            break;
        }
    }

    public void tick() {
        super.tick();
        this.pages.forEach(p -> p.tick());
    }

    private List<ResearchDiscipline> buildDisciplineList() {
        return ResearchDisciplines.streamIndexDisciplines(this.minecraft.level.registryAccess()).toList();
    }

    private List<ResearchEntry> buildEntryList(ResearchDiscipline discipline) {
        return discipline.getEntryStream(this.minecraft.level.registryAccess()).sorted(Comparator.comparing(e -> Component.translatable((String)e.getNameTranslationKey()).getString())).collect(Collectors.toList());
    }

    protected void parseIndexPages() {
        this.currentStageIndex = 0;
        List<ResearchDiscipline> disciplines = this.buildDisciplineList();
        if (disciplines.isEmpty()) {
            return;
        }
        int heightRemaining = 182;
        DisciplineIndexPage tempPage = new DisciplineIndexPage(true);
        for (ResearchDiscipline discipline : disciplines) {
            if (!discipline.unlockRequirementOpt().isEmpty() && !discipline.unlockRequirementOpt().get().isMetBy((Player)Minecraft.getInstance().player)) continue;
            tempPage.addDiscipline(discipline);
            if ((heightRemaining -= 12) >= 12 || tempPage.getDisciplines().isEmpty()) continue;
            heightRemaining = 210;
            this.pages.add(tempPage);
            tempPage = new DisciplineIndexPage();
        }
        if (!tempPage.getDisciplines().isEmpty()) {
            this.pages.add(tempPage);
        }
        this.pages.add(new OtherIndexPage());
    }

    protected void parseDisciplinePages(ResearchDisciplineKey disciplineKey) {
        Minecraft mc = this.minecraft;
        RegistryAccess registryAccess = mc.level.registryAccess();
        this.currentStageIndex = 0;
        if (disciplineKey == null) {
            return;
        }
        ResearchDiscipline discipline = ResearchDisciplines.getDiscipline(registryAccess, disciplineKey);
        if (discipline == null) {
            return;
        }
        List<ResearchEntry> entries = this.buildEntryList(discipline);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<ResearchEntry> newList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> updatedList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> completeList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> inProgressList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> availableList = new ArrayList<ResearchEntry>();
        ArrayList<ResearchEntry> upcomingList = new ArrayList<ResearchEntry>();
        for (ResearchEntry entry : entries) {
            if (entry.isNew((Player)mc.player)) {
                newList.add(entry);
                continue;
            }
            if (entry.isUpdated((Player)mc.player)) {
                updatedList.add(entry);
                continue;
            }
            if (entry.isComplete((Player)mc.player)) {
                completeList.add(entry);
                continue;
            }
            if (entry.isInProgress((Player)mc.player)) {
                inProgressList.add(entry);
                continue;
            }
            if (!entry.flags().hidden() && entry.isAvailable((Player)mc.player)) {
                availableList.add(entry);
                continue;
            }
            if (entry.flags().hidden() || !entry.isUpcoming((Player)mc.player)) continue;
            upcomingList.add(entry);
        }
        if (upcomingList.isEmpty()) {
            ResearchEntry unknownEntry;
            ArrayList<ResearchEntry> discFinales = new ArrayList<ResearchEntry>(discipline.getFinaleEntries(registryAccess));
            if (!entries.stream().filter(e -> !discFinales.contains(e)).allMatch(e -> e.isVisible((Player)mc.player)) && (unknownEntry = ResearchEntries.getEntry(registryAccess, ResearchEntries.UNKNOWN_RESEARCH)) != null) {
                upcomingList.add(unknownEntry);
            }
        }
        DisciplinePageProperties properties = new DisciplinePageProperties();
        properties.heightRemaining = 137;
        properties.firstSection = true;
        properties.page = new DisciplinePage(discipline, true);
        if (!updatedList.isEmpty()) {
            this.parseDisciplinePageSection(updatedList, "updated", discipline, properties);
        }
        if (!newList.isEmpty()) {
            this.parseDisciplinePageSection(newList, "new", discipline, properties);
        }
        if (!inProgressList.isEmpty()) {
            this.parseDisciplinePageSection(inProgressList, "in_progress", discipline, properties);
        }
        if (!availableList.isEmpty()) {
            this.parseDisciplinePageSection(availableList, "available", discipline, properties);
        }
        if (!upcomingList.isEmpty()) {
            this.parseDisciplinePageSection(upcomingList, "upcoming", discipline, properties);
        }
        if (!completeList.isEmpty()) {
            this.parseDisciplinePageSection(completeList, "complete", discipline, properties);
        }
        if (!properties.page.getContents().isEmpty()) {
            this.pages.add(properties.page);
        }
    }

    protected void parseDisciplinePageSection(List<ResearchEntry> researchList, String headerName, ResearchDiscipline discipline, DisciplinePageProperties properties) {
        MutableComponent headerText = Component.translatable((String)("grimoire.primalmagick.section_header." + headerName)).withStyle(ChatFormatting.UNDERLINE);
        if (properties.heightRemaining < 36 && !properties.page.getContents().isEmpty()) {
            properties.heightRemaining = 156;
            this.pages.add(properties.page);
            properties.page = new DisciplinePage(discipline);
            properties.page.addContent(headerText);
        } else {
            if (!properties.firstSection && !properties.page.getContents().isEmpty()) {
                properties.page.addContent(Component.literal((String)""));
                properties.heightRemaining -= 12;
            }
            properties.page.addContent(headerText);
            properties.heightRemaining -= 12;
        }
        properties.firstSection = false;
        for (ResearchEntry entry : researchList) {
            properties.page.addContent(entry);
            properties.heightRemaining -= 12;
            if (properties.heightRemaining > 12 || properties.page.getContents().isEmpty()) continue;
            properties.heightRemaining = 156;
            this.pages.add(properties.page);
            properties.page = new DisciplinePage(discipline);
        }
    }

    private Tuple<List<String>, List<PageImage>> parseText(String rawText) {
        String[] imgSplit;
        rawText = rawText.replaceAll("<BR>", "~B\n\n");
        rawText = rawText.replaceAll("<LINE>", "~L");
        rawText = rawText.replaceAll("<PAGE>", "~P");
        ArrayList<PageImage> images = new ArrayList<PageImage>();
        for (String imgStr : imgSplit = rawText.split("<IMG>")) {
            int index = imgStr.indexOf("</IMG>");
            if (index < 0) continue;
            String cleanStr = imgStr.substring(0, index);
            PageImage newImage = PageImage.parse(cleanStr);
            if (newImage == null) {
                rawText = rawText.replaceFirst(cleanStr, "\n");
                continue;
            }
            images.add(newImage);
            rawText = rawText.replaceFirst(cleanStr, "~I");
        }
        rawText = rawText.replaceAll("<IMG>", "");
        rawText = rawText.replaceAll("</IMG>", "");
        ArrayList<String> firstPassText = new ArrayList<String>();
        String[] pageTokens = rawText.split("~P");
        for (int i = 0; i < pageTokens.length; ++i) {
            String[] lineTokens = pageTokens[i].split("~L");
            for (int j = 0; j < lineTokens.length; ++j) {
                String[] imgTokens = lineTokens[j].split("~I");
                for (int k = 0; k < imgTokens.length; ++k) {
                    firstPassText.add(imgTokens[k]);
                    if (k == imgTokens.length - 1) continue;
                    firstPassText.add("~I");
                }
                if (j == lineTokens.length - 1) continue;
                firstPassText.add("~L");
            }
            if (i == pageTokens.length - 1) continue;
            firstPassText.add("~P");
        }
        ArrayList parsedText = new ArrayList();
        for (String str : firstPassText) {
            parsedText.addAll(this.font.getSplitter().splitLines(FormattedText.of((String)str), 124, Style.EMPTY));
        }
        return new Tuple(parsedText.stream().map(t -> t.getString()).collect(Collectors.toList()), images);
    }

    protected void parseEntryPages(ResearchEntryKey entryKey) {
        if (entryKey == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        RegistryAccess registryAccess = mc.level.registryAccess();
        ResearchEntry entry = ResearchEntries.getEntry(registryAccess, entryKey);
        if (entry == null || entry.stages().isEmpty()) {
            return;
        }
        LocalPlayer player = this.minecraft.player;
        ClientLevel level = this.minecraft.level;
        boolean complete = false;
        this.currentStageIndex = this.knowledge.getResearchStage(entry.key());
        if (this.currentStageIndex >= entry.stages().size()) {
            this.currentStageIndex = entry.stages().size() - 1;
            complete = true;
        }
        if (this.currentStageIndex < 0) {
            this.currentStageIndex = 0;
        }
        ResearchStage stage = entry.stages().get(this.currentStageIndex);
        List<Object> addenda = complete ? entry.addenda() : Collections.emptyList();
        Object rawText = Component.translatable((String)stage.textTranslationKey()).getString();
        int addendumCount = 0;
        for (ResearchAddendum researchAddendum : addenda) {
            if (!researchAddendum.completionRequirementOpt().isPresent() || !researchAddendum.completionRequirementOpt().get().isMetBy((Player)player)) continue;
            MutableComponent headerText = Component.translatable((String)"grimoire.primalmagick.addendum_header", (Object[])new Object[]{++addendumCount});
            MutableComponent addendumText = Component.translatable((String)researchAddendum.textTranslationKey());
            rawText = (String)rawText + "<PAGE>" + headerText.getString() + "<BR>" + addendumText.getString();
        }
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> tuple = this.parseText((String)rawText);
        List parsedText = (List)tuple.getA();
        List images = (List)tuple.getB();
        int heightRemaining = 137;
        StagePage tempPage = new StagePage(stage, true);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (Object line : parsedText) {
            if (((String)line).contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (((String)line).contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (((String)line).contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new StagePage(stage);
                heightRemaining = 165;
                line = "";
            }
            if (!((String)line).isEmpty()) {
                line = ((String)line).trim();
                tempPage.addElement(new PageString((String)line));
                heightRemaining -= lineHeight;
                if (((String)line).endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new StagePage(stage);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        if (!tempImages.isEmpty()) {
            tempPage = new StagePage(stage);
            heightRemaining = 165;
            while (!tempImages.isEmpty()) {
                if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                    heightRemaining = 165;
                    this.pages.add(tempPage);
                    tempPage = new StagePage(stage);
                    continue;
                }
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (!tempPage.getElements().isEmpty()) {
                this.pages.add(tempPage);
            }
        }
        if (stage.ctaLinkOpt().isPresent()) {
            TopicLink link = stage.ctaLinkOpt().get();
            if (heightRemaining < 22) {
                tempPage = new StagePage(stage);
                tempPage.setTopicLink(link);
                this.pages.add(tempPage);
            } else {
                tempPage.setTopicLink(link);
            }
        }
        SourceList attunements = stage.attunements();
        for (ResearchAddendum researchAddendum : addenda) {
            if (!researchAddendum.completionRequirementOpt().isEmpty() && !researchAddendum.completionRequirementOpt().get().isMetBy((Player)player)) continue;
            attunements = attunements.merge(researchAddendum.attunements());
        }
        if (!attunements.isEmpty()) {
            this.pages.add(new AttunementGainPage(attunements));
        }
        if (!entry.key().isKnownBy((Player)player) && stage.hasPrerequisites()) {
            this.pages.add(new RequirementsPage(stage));
        }
        ArrayList<ResourceLocation> locList = new ArrayList<ResourceLocation>();
        for (ResourceLocation resourceLocation : stage.recipes()) {
            if (locList.contains(resourceLocation)) continue;
            locList.add(resourceLocation);
        }
        for (ResearchAddendum researchAddendum : addenda) {
            if (!researchAddendum.completionRequirementOpt().isEmpty() && !researchAddendum.completionRequirementOpt().get().isMetBy((Player)player)) continue;
            for (ResourceLocation loc : researchAddendum.recipes()) {
                if (locList.contains(loc)) continue;
                locList.add(loc);
            }
        }
        for (ResourceLocation resourceLocation : locList) {
            Optional opt = level.getRecipeManager().byKey(resourceLocation);
            opt.ifPresent(arg_0 -> this.lambda$parseEntryPages$6((Level)level, arg_0));
        }
    }

    protected void parseStatsPages() {
        this.currentStageIndex = 0;
        List<Stat> stats = StatsManager.getDisplayStats();
        if (stats.isEmpty()) {
            return;
        }
        int heightRemaining = 137;
        int dotWidth = this.font.width(".");
        StatisticsPage tempPage = new StatisticsPage(true);
        Minecraft mc = this.minecraft;
        for (Stat stat : stats) {
            String statFormattedValueStr;
            int statFormattedValueStrWidth;
            int statValue = StatsManager.getValue((Player)mc.player, stat);
            if (stat.hidden() && statValue <= 0) continue;
            MutableComponent statText = Component.translatable((String)stat.getTranslationKey());
            ArrayList<FormattedText> statTextSegments = new ArrayList<FormattedText>(this.font.getSplitter().splitLines((FormattedText)statText, 124, Style.EMPTY));
            FormattedText lastStatTextSegment = (FormattedText)statTextSegments.get(statTextSegments.size() - 1);
            int lastStatTextSegmentWidth = this.font.width(lastStatTextSegment);
            int remainingWidth = 124 - lastStatTextSegmentWidth - (statFormattedValueStrWidth = this.font.width(statFormattedValueStr = stat.formatter().format(statValue)));
            if (remainingWidth < 10) {
                String joiner1 = String.join((CharSequence)"", Collections.nCopies((124 - lastStatTextSegmentWidth) / dotWidth, "."));
                String joiner2 = String.join((CharSequence)"", Collections.nCopies((124 - statFormattedValueStrWidth) / dotWidth, "."));
                statTextSegments.set(statTextSegments.size() - 1, FormattedText.of((String)(lastStatTextSegment.getString() + joiner1)));
                statTextSegments.add(FormattedText.of((String)(joiner2 + statFormattedValueStr + "~B")));
            } else {
                String joiner = String.join((CharSequence)"", Collections.nCopies(remainingWidth / dotWidth, "."));
                statTextSegments.set(statTextSegments.size() - 1, FormattedText.of((String)(lastStatTextSegment.getString() + joiner + statFormattedValueStr + "~B")));
            }
            Objects.requireNonNull(this.font);
            int totalHeight = 9 * statTextSegments.size();
            if (heightRemaining < totalHeight && !tempPage.getElements().isEmpty()) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new StatisticsPage();
            }
            for (FormattedText str : statTextSegments) {
                tempPage.addElement(new PageString(str.getString()));
                Objects.requireNonNull(this.font);
                heightRemaining -= 9;
            }
            Objects.requireNonNull(this.font);
            heightRemaining -= (int)(9.0 * 0.66);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void parseLinguisticsIndexPages() {
        this.currentStageIndex = 0;
        this.pages.add(new LinguisticsIndexPage(true));
    }

    protected void parseLinguisticsPage(ResourceKey<BookLanguage> languageKey) {
        this.currentStageIndex = 0;
        Holder.Reference<BookLanguage> language = BookLanguagesPM.getLanguageOrDefault(languageKey, this.minecraft.level.registryAccess(), BookLanguagesPM.DEFAULT);
        this.pages.add(new LinguisticsScorePage((Holder<BookLanguage>)language));
        String rawText = ((BookLanguage)language.value()).getDescription().getString();
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> parsedData = this.parseText(rawText);
        List parsedText = (List)parsedData.getA();
        List images = (List)parsedData.getB();
        int heightRemaining = 165;
        LinguisticsDescriptionPage tempPage = new LinguisticsDescriptionPage((Holder<BookLanguage>)language);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (String line : parsedText) {
            if (line.contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (line.contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (line.contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new LinguisticsDescriptionPage((Holder<BookLanguage>)language);
                heightRemaining = 165;
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                tempPage.addElement(new PageString(line));
                heightRemaining -= lineHeight;
                if (line.endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new LinguisticsDescriptionPage((Holder<BookLanguage>)language);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new LinguisticsDescriptionPage((Holder<BookLanguage>)language);
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new LinguisticsDescriptionPage((Holder<BookLanguage>)language);
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void parseAffinityIndexPages() {
        this.currentStageIndex = 0;
        this.pages.add(new AffinityIndexPage(true));
    }

    protected void parseAffinityPage(Source source) {
        this.currentStageIndex = 0;
        Minecraft mc = Minecraft.getInstance();
        List<AffinityIndexEntry> entries = ResearchManager.getAffinityIndexEntries((Player)mc.player);
        List<CompletableFuture<SourceList>> affinityFutures = entries.stream().map(AffinityIndexEntry::affinities).toList();
        CompletableFuture<Void> loadedFuture = CompletableFuture.allOf((CompletableFuture[])affinityFutures.toArray(CompletableFuture[]::new));
        if (loadedFuture.isDone()) {
            List<AffinityIndexEntry> sortedEntries = entries.stream().filter(e -> e.affinities().join().getAmount(source) > 0).sorted(Comparator.comparing(e -> e.affinities().join().getAmount(source)).reversed().thenComparing(e -> e.stack().getDisplayName().getString())).toList();
            AffinityPage tempPage = new AffinityPage(source, loadedFuture, true);
            int lineHeight = 17;
            int heightRemaining = 137;
            for (AffinityIndexEntry entry : sortedEntries) {
                tempPage.addElement(entry);
                if ((heightRemaining -= 17) >= 17 || tempPage.getElements().isEmpty()) continue;
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new AffinityPage(source, loadedFuture, false);
            }
            if (sortedEntries.isEmpty() || !tempPage.getElements().isEmpty()) {
                this.pages.add(tempPage);
            }
        } else {
            loadedFuture.thenAccept($ -> this.setRefreshing());
            AffinityPage loadingPage = new AffinityPage(source, loadedFuture, true);
            loadingPage.setProgressFutures(affinityFutures);
            this.pages.add(loadingPage);
        }
    }

    protected void parseAttunementIndexPages() {
        this.currentStageIndex = 0;
        this.pages.add(new AttunementIndexPage(true));
    }

    protected void parseAttunementPage(Source source) {
        this.currentStageIndex = 0;
        this.pages.add(new AttunementPage(source, true));
        ResourceLocation sourceId = source.getId();
        String componentKey = String.join((CharSequence)".", "source", sourceId.getNamespace(), sourceId.getPath(), "attunement", "text");
        String rawText = Component.translatable((String)componentKey).getString();
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> parsedData = this.parseText(rawText);
        List parsedText = (List)parsedData.getA();
        List images = (List)parsedData.getB();
        int heightRemaining = 165;
        AttunementPage tempPage = new AttunementPage(source);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (String line : parsedText) {
            if (line.contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (line.contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (line.contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new AttunementPage(source);
                heightRemaining = 165;
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                tempPage.addElement(new PageString(line));
                heightRemaining -= lineHeight;
                if (line.endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new AttunementPage(source);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new AttunementPage(source);
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new AttunementPage(source);
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void parseRuneEnchantmentPage(Holder<Enchantment> enchant) {
        Minecraft mc = Minecraft.getInstance();
        ResourceLocation enchantKey = ((ResourceKey)enchant.unwrapKey().get()).location();
        String rawText = ResearchManager.isResearchComplete((Player)mc.player, new RuneEnchantmentKey(enchant)) ? Component.translatable((String)String.join((CharSequence)".", "enchantment", enchantKey.getNamespace(), enchantKey.getPath(), "rune_enchantment", "text")).getString() : Component.translatable((String)String.join((CharSequence)".", "enchantment", enchantKey.getNamespace(), enchantKey.getPath(), "rune_enchantment", "partial_text")).getString();
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> parsedData = this.parseText(rawText);
        List parsedText = (List)parsedData.getA();
        List images = (List)parsedData.getB();
        int heightRemaining = 113;
        RuneEnchantmentPage tempPage = new RuneEnchantmentPage(enchant, true);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (String line : parsedText) {
            if (line.contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (line.contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (line.contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new RuneEnchantmentPage(enchant);
                heightRemaining = 165;
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                tempPage.addElement(new PageString(line));
                heightRemaining -= lineHeight;
                if (line.endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new RuneEnchantmentPage(enchant);
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new RuneEnchantmentPage(enchant);
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new RuneEnchantmentPage(enchant);
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void parseRuneEnchantmentIndexPages() {
        this.currentStageIndex = 0;
        int heightRemaining = 137;
        RuneEnchantmentIndexPage tempPage = new RuneEnchantmentIndexPage(true);
        Minecraft mc = Minecraft.getInstance();
        for (Holder<Enchantment> enchant : RuneManager.getRuneEnchantmentsSorted(mc.level.registryAccess())) {
            List<RuneEnchantmentPartialKey> researchKeys = List.of(new RuneEnchantmentKey(enchant), new RuneEnchantmentPartialKey(enchant, RuneType.VERB), new RuneEnchantmentPartialKey(enchant, RuneType.NOUN), new RuneEnchantmentPartialKey(enchant, RuneType.SOURCE));
            if (!researchKeys.stream().anyMatch(key -> ResearchManager.isResearchComplete((Player)mc.player, key))) continue;
            tempPage.addEnchantment(enchant);
            if ((heightRemaining -= 12) >= 12 || tempPage.getEnchantments().isEmpty()) continue;
            heightRemaining = 156;
            this.pages.add(tempPage);
            tempPage = new RuneEnchantmentIndexPage();
        }
        if (!tempPage.getEnchantments().isEmpty()) {
            this.pages.add(tempPage);
        }
    }

    protected void generateIndexMap() {
        Minecraft mc = this.minecraft;
        Comparator<RecipeHolder> displayNameComparator = Comparator.comparing(r -> r.value().getResultItem((HolderLookup.Provider)mc.level.registryAccess()).getHoverName().getString());
        Comparator<RecipeHolder> recipeIdComparator = Comparator.comparing(r -> r.id());
        List processedRecipes = mc.level.getRecipeManager().getRecipes().stream().filter(GrimoireScreen::isValidRecipeIndexEntry).sorted(displayNameComparator.thenComparing(recipeIdComparator)).collect(Collectors.toList());
        this.indexMap = new TreeMap();
        for (RecipeHolder recipe : processedRecipes) {
            String recipeName = recipe.value().getResultItem((HolderLookup.Provider)mc.level.registryAccess()).getHoverName().getString();
            if (!this.indexMap.containsKey(recipeName)) {
                this.indexMap.put(recipeName, new ArrayList());
            }
            ((List)this.indexMap.get(recipeName)).add(recipe);
        }
    }

    public boolean isIndexKey(String name) {
        return this.indexMap.containsKey(name);
    }

    public void checkRecipeSearchStringUpdate(String newString) {
        if (!newString.equals(this.lastRecipeSearch.orElse(""))) {
            this.lastRecipeSearch = Optional.ofNullable(newString);
            this.initPages();
            this.initButtons();
        }
    }

    protected void parseRecipeIndexPages() {
        this.currentStageIndex = 0;
        Minecraft mc = this.minecraft;
        int heightRemaining = 113;
        RecipeIndexPage tempPage = new RecipeIndexPage(true, this.lastRecipeSearch);
        for (String recipeName : this.indexMap.navigableKeySet()) {
            if (!recipeName.toLowerCase(Locale.ROOT).contains(this.lastRecipeSearch.orElse("").toLowerCase(Locale.ROOT))) continue;
            tempPage.addContent(recipeName, ((RecipeHolder)((List)this.indexMap.get(recipeName)).get(0)).value().getResultItem((HolderLookup.Provider)mc.level.registryAccess()));
            if ((heightRemaining -= 12) >= 12 || tempPage.getContents().isEmpty()) continue;
            heightRemaining = 156;
            this.pages.add(tempPage);
            tempPage = new RecipeIndexPage();
        }
        if (!tempPage.getContents().isEmpty() || tempPage.getContents().isEmpty() && tempPage.isFirstPage()) {
            this.pages.add(tempPage);
        }
        if (this.pages.isEmpty()) {
            LOGGER.warn("Finished parsing recipe index pages without adding any!");
        }
    }

    protected static boolean isValidRecipeIndexEntry(RecipeHolder<?> recipe) {
        Minecraft mc = Minecraft.getInstance();
        RegistryAccess registryAccess = mc.level.registryAccess();
        if (!recipe.id().getNamespace().equals("primalmagick") || recipe.value().getResultItem((HolderLookup.Provider)registryAccess).isEmpty()) {
            return false;
        }
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof IHasRequirement) {
            IHasRequirement hrr = (IHasRequirement)recipe2;
            return hrr.getRequirement().isEmpty() || hrr.getRequirement().get().isMetBy((Player)mc.player);
        }
        return ResearchManager.isRecipeVisible(recipe.id(), (Player)mc.player);
    }

    protected void parseRecipeEntryPages(String recipeName) {
        Minecraft mc = Minecraft.getInstance();
        this.currentStageIndex = 0;
        boolean firstPage = true;
        List recipes = this.indexMap.getOrDefault(recipeName, Collections.emptyList());
        for (RecipeHolder recipe : recipes) {
            AbstractRecipePage page = RecipePageFactory.createPage(recipe, mc.level.registryAccess());
            if (page == null) continue;
            this.pages.add(new RecipeMetadataPage(recipe, mc.level.registryAccess(), firstPage));
            this.pages.add(page);
            firstPage = false;
        }
    }

    protected Component getCurrentTip() {
        if (this.cachedTip == null) {
            Minecraft mc = Minecraft.getInstance();
            this.cachedTip = TipDefinitionsPM.getRandom((Player)mc.player, mc.player.getRandom()).map(TipDefinition::getText).orElse((Component)Component.empty());
        }
        return this.cachedTip;
    }

    public void invalidateCurrentTip() {
        this.cachedTip = null;
    }

    protected void parseTipsPages() {
        TipsPage lastPage;
        int contentHeight;
        String rawText = StringDecomposer.getPlainText((FormattedText)this.getCurrentTip());
        Objects.requireNonNull(this.font);
        int lineHeight = 9;
        Tuple<List<String>, List<PageImage>> parsedData = this.parseText(rawText);
        List parsedText = (List)parsedData.getA();
        List images = (List)parsedData.getB();
        int heightRemaining = 137;
        TipsPage tempPage = new TipsPage(true);
        ArrayList<PageImage> tempImages = new ArrayList<PageImage>();
        for (String line : parsedText) {
            if (line.contains("~I")) {
                if (!images.isEmpty()) {
                    tempImages.add((PageImage)images.remove(0));
                }
                line = "";
            }
            if (line.contains("~L")) {
                tempImages.add(IMAGE_LINE);
                line = "";
            }
            if (line.contains("~P")) {
                this.pages.add(tempPage);
                tempPage = new TipsPage();
                heightRemaining = 165;
                line = "";
            }
            if (!line.isEmpty()) {
                line = line.trim();
                tempPage.addElement(new PageString(line));
                heightRemaining -= lineHeight;
                if (line.endsWith("~B")) {
                    heightRemaining -= (int)((double)lineHeight * 0.66);
                }
            }
            while (!tempImages.isEmpty() && heightRemaining >= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
                tempPage.addElement((IPageElement)tempImages.remove(0));
            }
            if (heightRemaining >= lineHeight || tempPage.getElements().isEmpty()) continue;
            heightRemaining = 165;
            this.pages.add(tempPage);
            tempPage = new TipsPage();
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        tempPage = new TipsPage();
        heightRemaining = 165;
        while (!tempImages.isEmpty()) {
            if (heightRemaining < ((PageImage)tempImages.get((int)0)).adjustedHeight + 2) {
                heightRemaining = 165;
                this.pages.add(tempPage);
                tempPage = new TipsPage();
                continue;
            }
            heightRemaining -= ((PageImage)tempImages.get((int)0)).adjustedHeight + 2;
            tempPage.addElement((IPageElement)tempImages.remove(0));
        }
        if (!tempPage.getElements().isEmpty()) {
            this.pages.add(tempPage);
        }
        if ((contentHeight = (lastPage = (TipsPage)this.pages.get(this.pages.size() - 1)).getElements().stream().mapToInt(IPageElement::getHeight).sum()) > (lastPage.isFirstPage() ? 112 : 140)) {
            lastPage = new TipsPage();
            this.pages.add(lastPage);
        }
        lastPage.setLastPage(true);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int newPage) {
        this.currentPage = newPage;
        this.lastStageIndex = this.currentStageIndex;
    }

    public boolean nextPage() {
        if (this.currentPage < this.pages.size() - 2) {
            this.currentPage += 2;
            this.initButtons();
            return true;
        }
        return false;
    }

    public boolean prevPage() {
        if (this.currentPage >= 2) {
            this.currentPage -= 2;
            this.initButtons();
            return true;
        }
        return false;
    }

    public boolean goBack() {
        if (!this.knowledge.getResearchTopicHistory().isEmpty()) {
            AbstractResearchTopic<?> lastTopic = this.knowledge.getResearchTopicHistory().pop();
            this.knowledge.setLastResearchTopic(lastTopic);
            this.minecraft.setScreen((Screen)new GrimoireScreen());
            return true;
        }
        return false;
    }

    public Optional<AbstractResearchTopic<?>> getPreviousTopic() {
        return Optional.ofNullable(this.knowledge.getResearchTopicHistory().peek());
    }

    public void gotoTopic(AbstractResearchTopic<?> newTopic) {
        this.gotoTopic(newTopic, true);
    }

    public void gotoTopic(AbstractResearchTopic<?> newTopic, boolean allowRepeatInHistory) {
        if (allowRepeatInHistory || !this.knowledge.getLastResearchTopic().equals(newTopic)) {
            this.pushCurrentHistoryTopic();
        }
        this.setTopic(newTopic);
        this.minecraft.setScreen((Screen)new GrimoireScreen());
    }

    protected void updateNavButtonVisibility() {
        this.prevPageButton.visible = this.currentPage >= 2;
        this.nextPageButton.visible = this.currentPage < this.pages.size() - 2;
        this.backButton.visible = !this.knowledge.getResearchTopicHistory().isEmpty();
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        for (AbstractPage page : this.pages) {
            if (!page.charTyped(pCodePoint, pModifiers)) continue;
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (AbstractPage page : this.pages) {
            if (!page.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == Services.INPUT.getKey(KeyBindings.GRIMOIRE_PREV_TOPIC).getValue()) {
            if (this.goBack()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
                return true;
            }
        } else if (keyCode == Services.INPUT.getKey(KeyBindings.GRIMOIRE_PREV_PAGE).getValue()) {
            if (this.prevPage()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
                return true;
            }
        } else if (keyCode == Services.INPUT.getKey(KeyBindings.GRIMOIRE_NEXT_PAGE).getValue() && this.nextPage()) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double xPos, double yPos, int keyCode) {
        boolean retVal = super.mouseClicked(xPos, yPos, keyCode);
        if (keyCode == 1) {
            if (this.goBack()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
            }
        } else if (keyCode == 3) {
            if (this.prevPage()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
            }
        } else if (keyCode == 4) {
            if (this.nextPage()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
            }
        } else {
            for (AbstractPage page : this.pages) {
                if (!page.mouseClicked(xPos, yPos, keyCode)) continue;
                this.setFocused(page);
                return true;
            }
            this.setFocused(null);
        }
        return retVal;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY > 0.0) {
            if (this.prevPage()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
            }
        } else if (pScrollY < 0.0 && this.nextPage()) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundsPM.PAGE.get(), (float)1.0f, (float)1.0f));
        }
        return true;
    }

    public void pushCurrentHistoryTopic() {
        this.knowledge.getResearchTopicHistory().push((AbstractResearchTopic<?>)this.knowledge.getLastResearchTopic().withPage(this.getCurrentPage()));
    }

    public void setTopic(AbstractResearchTopic<?> newTopic) {
        this.knowledge.setLastResearchTopic(newTopic);
    }

    public List<AbstractResearchTopic<?>> getHistoryView() {
        return this.knowledge.getResearchTopicHistory().subList(0, Math.min(this.knowledge.getResearchTopicHistory().size(), 64));
    }

    private /* synthetic */ void lambda$parseEntryPages$6(Level level, RecipeHolder recipe) {
        AbstractRecipePage page = RecipePageFactory.createPage(recipe, level.registryAccess());
        if (page != null) {
            this.pages.add(page);
        }
    }

    protected static class DisciplinePageProperties {
        public DisciplinePage page;
        public int heightRemaining;
        public boolean firstSection;

        protected DisciplinePageProperties() {
        }
    }
}

