/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.client.gui.AbstractContainerScreenPM;
import com.verdantartifice.primalmagick.client.gui.widgets.EssenceCaskWidget;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.EssenceCaskMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.WithdrawCaskEssencePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class EssenceCaskScreen
extends AbstractContainerScreenPM<EssenceCaskMenu> {
    protected static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/essence_cask.png");
    protected final List<EssenceCaskWidget> caskWidgets = new ArrayList<EssenceCaskWidget>();
    protected long lastCheck = 0L;
    protected int lastTotalEssence = 0;

    public EssenceCaskScreen(EssenceCaskMenu screenMenu, Inventory inv, Component titleIn) {
        super(screenMenu, inv, titleIn);
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.lastTotalEssence = ((EssenceCaskMenu)this.menu).getTotalEssenceCount();
        this.initWidgets();
    }

    protected void initWidgets() {
        Minecraft mc = Minecraft.getInstance();
        this.clearWidgets();
        this.caskWidgets.clear();
        int visibleRows = Arrays.stream(EssenceType.values()).mapToInt(t -> ((EssenceCaskMenu)this.menu).isEssenceTypeVisible((EssenceType)((Object)t), (Player)mc.player) ? 1 : 0).sum();
        int visibleCols = Sources.getAllSorted().stream().mapToInt(s -> ((EssenceCaskMenu)this.menu).isEssenceSourceVisible((Source)s, (Player)mc.player) ? 1 : 0).sum();
        int startX = this.leftPos + 8 + (Sources.getAllSorted().size() - visibleCols) * 18 / 2;
        int startY = this.topPos + 18 + (EssenceType.values().length - visibleRows) * 18 / 2;
        int index = 0;
        int xPos = startX;
        int yPos = startY;
        for (int row = 0; row < EssenceType.values().length; ++row) {
            boolean rowPopulated = false;
            for (int col = 0; col < Sources.getAllSorted().size(); ++col) {
                EssenceType cellType = EssenceType.values()[row];
                Source cellSource = Sources.getAllSorted().get(col);
                if (((EssenceCaskMenu)this.menu).isEssenceTypeVisible(cellType, (Player)mc.player) && ((EssenceCaskMenu)this.menu).isEssenceSourceVisible(cellSource, (Player)mc.player)) {
                    int count = ((EssenceCaskMenu)this.menu).getEssenceCount(index);
                    this.caskWidgets.add((EssenceCaskWidget)this.addRenderableWidget((GuiEventListener)new EssenceCaskWidget(index, cellType, cellSource, count, xPos, yPos, this::onWidgetClicked)));
                    xPos += 18;
                    rowPopulated = true;
                }
                ++index;
            }
            xPos = startX;
            if (!rowPopulated) continue;
            yPos += 18;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        long millis = System.currentTimeMillis();
        if (millis > this.lastCheck || this.lastTotalEssence != ((EssenceCaskMenu)this.menu).getTotalEssenceCount()) {
            this.lastCheck = millis + 2000L;
            this.lastTotalEssence = ((EssenceCaskMenu)this.menu).getTotalEssenceCount();
            this.initWidgets();
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        for (EssenceCaskWidget widget : this.caskWidgets) {
            if (!widget.isHovered()) continue;
            EssenceCaskScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)widget.getX(), (int)widget.getY(), (int)0);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        MutableComponent contentsLabel = Component.translatable((String)"label.primalmagick.essence_cask.contents", (Object[])new Object[]{((EssenceCaskMenu)this.menu).getTotalEssenceCount(), ((EssenceCaskMenu)this.menu).getTotalEssenceCapacity()});
        guiGraphics.drawString(this.font, (Component)contentsLabel, 8, 92, 0x404040, false);
    }

    protected void onWidgetClicked(EssenceCaskWidget widget, int clickButton) {
        int toRemove = clickButton == 1 ? 1 : 64;
        PacketHandler.sendToServer(new WithdrawCaskEssencePacket(widget.getEssenceType(), widget.getSource(), toRemove, ((EssenceCaskMenu)this.menu).getTilePos()));
    }
}

