/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.client.gui.AbstractContainerScreenPM;
import com.verdantartifice.primalmagick.client.gui.widgets.AffinityWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.KnowledgeTotalWidget;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.menus.AnalysisTableMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.AnalysisActionPacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableObject;

public class AnalysisTableScreen
extends AbstractContainerScreenPM<AnalysisTableMenu> {
    private static final ResourceLocation TEXTURE = ResourceUtils.loc("textures/gui/analysis_table.png");
    protected Level world;
    protected final List<AffinityWidget> affinityWidgets = new ArrayList<AffinityWidget>();

    public AnalysisTableScreen(AnalysisTableMenu screenMenu, Inventory inv, Component titleIn) {
        super(screenMenu, inv, titleIn);
        this.world = inv.player.level();
    }

    protected void init() {
        super.init();
        this.initControlWidgets();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.initAffinityWidgets();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableObject text = new MutableObject(null);
        ItemStack lastScannedStack = ((AnalysisTableMenu)this.menu).getLastScannedStack();
        if (lastScannedStack == null || lastScannedStack.isEmpty()) {
            text.setValue((Object)Component.translatable((String)"label.primalmagick.analysis.no_item"));
        } else {
            AffinityManager.getInstance().getAffinityValues(lastScannedStack, this.world).ifPresentOrElse(sources -> {
                if (sources == null || sources.isEmpty()) {
                    text.setValue((Object)Component.translatable((String)"label.primalmagick.analysis.no_affinities"));
                }
            }, () -> text.setValue((Object)Component.translatable((String)"label.primalmagick.analysis.calculating")));
        }
        if (text.getValue() != null) {
            int width = this.font.width(((Component)text.getValue()).getString());
            int x = 1 + (this.imageWidth - width) / 2;
            Objects.requireNonNull(this.font);
            int y = 10 + (16 - 9) / 2;
            guiGraphics.drawString(this.font, (Component)text.getValue(), x, y, Color.BLACK.getRGB(), false);
        }
    }

    protected void initControlWidgets() {
        this.addRenderableWidget((GuiEventListener)new AnalyzeButton((AnalysisTableMenu)this.menu, this.leftPos, this.topPos));
        this.addRenderableWidget((GuiEventListener)new KnowledgeTotalWidget(this.leftPos + 8, this.topPos + 60, KnowledgeType.OBSERVATION));
    }

    protected void initAffinityWidgets() {
        this.affinityWidgets.forEach(widget -> this.removeWidget((GuiEventListener)widget));
        this.affinityWidgets.clear();
        ItemStack lastScannedStack = ((AnalysisTableMenu)this.menu).getLastScannedStack();
        if (lastScannedStack != null && !lastScannedStack.isEmpty()) {
            AffinityManager.getInstance().getAffinityValues(lastScannedStack, this.world).ifPresent(sources -> {
                if (!sources.isEmpty()) {
                    int widgetSetWidth = sources.getSourcesSorted().size() * 18;
                    int x = this.leftPos + 1 + (this.imageWidth - widgetSetWidth) / 2;
                    int y = this.topPos + 10;
                    for (Source source : sources.getSourcesSorted()) {
                        this.affinityWidgets.add((AffinityWidget)this.addRenderableWidget((GuiEventListener)new AffinityWidget(source, sources.getAmount(source), x, y)));
                        x += 18;
                    }
                }
            });
        }
    }

    protected static class AnalyzeButton
    extends ImageButton {
        protected static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(ResourceUtils.loc("analysis_table/button"), ResourceUtils.loc("analysis_table/button_highlighted"));
        protected static final Component ANALYZE_BUTTON_TOOLTIP_1 = Component.translatable((String)"tooltip.primalmagick.analyze_button.1");
        protected static final Component ANALYZE_BUTTON_TOOLTIP_2 = Component.translatable((String)"tooltip.primalmagick.analyze_button.2").withStyle(ChatFormatting.RED);

        public AnalyzeButton(AnalysisTableMenu menu, int leftPos, int topPos) {
            super(leftPos + 78, topPos + 34, 20, 18, BUTTON_SPRITES, button -> PacketHandler.sendToServer(new AnalysisActionPacket(menu.containerId)));
            this.setTooltip(Tooltip.create((Component)CommonComponents.joinLines((Component[])new Component[]{ANALYZE_BUTTON_TOOLTIP_1, ANALYZE_BUTTON_TOOLTIP_2})));
        }
    }
}

