/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.common.menus.slots.IHasCyclingBackgrounds;
import com.verdantartifice.primalmagick.common.menus.slots.IHasTooltip;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public abstract class AbstractContainerScreenPM<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public AbstractContainerScreenPM(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
    }

    protected void containerTick() {
        super.containerTick();
        this.menu.slots.stream().forEach(slot -> {
            if (slot instanceof IHasCyclingBackgrounds) {
                IHasCyclingBackgrounds bgSlot = (IHasCyclingBackgrounds)slot;
                bgSlot.tickBackgrounds();
            }
        });
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        IHasTooltip tooltipSlot;
        super.renderTooltip(pGuiGraphics, pX, pY);
        Optional<Component> tooltipOpt = Optional.empty();
        Slot slot = this.hoveredSlot;
        if (slot instanceof IHasTooltip && (tooltipSlot = (IHasTooltip)slot).shouldShowTooltip()) {
            tooltipOpt = Optional.ofNullable(tooltipSlot.getTooltip());
        }
        tooltipOpt.ifPresent(tooltip -> pGuiGraphics.renderTooltip(this.font, tooltip, pX, pY));
    }
}

